/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators;

import android.widget.EditText;
import convalida.validators.AbstractValidator;
import convalida.validators.util.EditTextUtils;
import convalida.validators.util.ExecuteValidationListener;
import java.math.BigDecimal;

public class BetweenValidator
extends AbstractValidator {
    private EditText endEditText;
    private String endErrorMessage;
    private boolean endFieldHasError = false;

    public BetweenValidator(EditText startEditText, EditText endEditText, String startErrorMessage, String endErrorMessage, boolean startAutoDismiss, boolean endAutoDismiss) {
        super(startEditText, startErrorMessage, startAutoDismiss);
        this.endEditText = endEditText;
        this.endErrorMessage = endErrorMessage;
        if (endAutoDismiss) {
            EditTextUtils.addOnTextChangedListener(endEditText, new ExecuteValidationListener(){

                @Override
                public void execute(String value) {
                    BetweenValidator.this.applyValidationToEndField();
                }
            });
        }
    }

    private boolean endFieldIsValid() {
        String startValue = this.editText.getText().toString();
        String endValue = this.endEditText.getText().toString();
        try {
            BigDecimal startValueBigDecimal = new BigDecimal(startValue);
            BigDecimal endValueBigDecimal = new BigDecimal(endValue);
            return startValueBigDecimal.compareTo(endValueBigDecimal) <= 0;
        }
        catch (NumberFormatException e) {
            return startValue.compareTo(endValue) <= 0;
        }
    }

    private void applyValidationToEndField() {
        boolean bl = this.endFieldHasError = !this.endFieldIsValid();
        if (this.endFieldIsValid()) {
            EditTextUtils.setError(this.editText, null);
            EditTextUtils.setError(this.endEditText, null);
        } else {
            EditTextUtils.setError(this.editText, this.errorMessage);
            EditTextUtils.setError(this.endEditText, this.endErrorMessage);
        }
    }

    @Override
    public boolean isValid(String value) {
        this.applyValidationToEndField();
        String endFieldValue = this.endEditText.getText().toString();
        return !value.isEmpty() && (value.equals(endFieldValue) || !endFieldValue.isEmpty() && !this.endFieldHasError);
    }
}

