/*
 * Decompiled with CFR 0.152.
 */
package convalida.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import convalida.annotations.CpfValidation;
import convalida.annotations.CreditCardValidation;
import convalida.annotations.EmailValidation;
import convalida.annotations.LengthValidation;
import convalida.annotations.NumberLimitValidation;
import convalida.annotations.OnlyNumberValidation;
import convalida.annotations.PasswordValidation;
import convalida.annotations.PatternValidation;
import convalida.compiler.Constants;
import convalida.compiler.internal.ValidationClass;
import convalida.compiler.internal.ValidationField;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

class JavaFiler {
    JavaFiler() {
    }

    static JavaFile cookJava(ValidationClass validationClass) {
        TypeSpec.Builder validationClassBuilder = TypeSpec.classBuilder((String)validationClass.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField((TypeName)Constants.VALIDATOR_SET, "validatorSet", new Modifier[]{Modifier.PRIVATE}).addMethod(JavaFiler.createConstructor(validationClass)).addMethod(JavaFiler.createDatabindingConstructor(validationClass)).addMethod(JavaFiler.createValidateOnClickListener(validationClass)).addMethod(JavaFiler.createClearValidationsOnClickListener(validationClass)).addMethod(JavaFiler.createInitMethod(validationClass)).addMethod(JavaFiler.createInitDatabindingMethod(validationClass));
        return JavaFile.builder((String)validationClass.packageName, (TypeSpec)validationClassBuilder.build()).addFileComment("Generated code from Convalida. Do not modify!", new Object[0]).build();
    }

    private static MethodSpec createConstructor(ValidationClass validationClass) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(Constants.UI_THREAD).addParameter(ParameterSpec.builder((TypeName)validationClass.typeName, (String)"target", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(Constants.NON_NULL).build()).addStatement("validatorSet = new $T()", new Object[]{Constants.VALIDATOR_SET}).addCode(JavaFiler.createValidationsCodeBlock(validationClass)).addCode(JavaFiler.createValidateOnClickCodeBlock(validationClass)).addCode(JavaFiler.createClearValidationsOnClickCodeBlock(validationClass)).build();
    }

    private static MethodSpec createDatabindingConstructor(ValidationClass validationClass) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(Constants.UI_THREAD).addParameter(ParameterSpec.builder((TypeName)validationClass.typeName, (String)"target", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(Constants.NON_NULL).build()).addParameter(ParameterSpec.builder((TypeName)Constants.VIEW_DATA_BINDING, (String)"binding", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(Constants.NON_NULL).build()).addCode("if (binding.hasPendingBindings()) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("binding.executePendingBindings();", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addStatement("validatorSet = new $T()", new Object[]{Constants.VALIDATOR_SET}).addCode("$T<$T> views = $T.getViewsByTag(($T) binding.getRoot(), $T.id.validation_type);", new Object[]{Constants.LIST, Constants.VIEW, Constants.VIEW_TAG_UTILS, Constants.VIEWGROUP, Constants.CONVALIDA_DATABINDING_R}).addCode("\n", new Object[0]).addCode("$T<$T> buttons = $T.getViewsByTag(($T) binding.getRoot(), $T.id.validation_action);", new Object[]{Constants.LIST, Constants.VIEW, Constants.VIEW_TAG_UTILS, Constants.VIEWGROUP, Constants.CONVALIDA_DATABINDING_R}).addCode("\n", new Object[0]).addCode("$T validateButton = null;", new Object[]{Constants.BUTTON}).addCode("\n", new Object[0]).addCode("$T clearValidationsButton = null;", new Object[]{Constants.BUTTON}).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addCode("for (View view : views) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("validatorSet.addValidator(($T) view.getTag($T.id.validation_type));", new Object[]{Constants.ABSTRACT_VALIDATOR, Constants.CONVALIDA_DATABINDING_R}).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addCode("for (View button : buttons) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("if (button.getTag($T.id.validation_action).equals($T.id.validate) && validateButton == null) {", new Object[]{Constants.CONVALIDA_DATABINDING_R, Constants.CONVALIDA_DATABINDING_R}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("validateButton = ($T) button;", new Object[]{Constants.BUTTON}).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addCode("if (button.getTag($T.id.validation_action).equals($T.id.clear) && clearValidationsButton == null) {", new Object[]{Constants.CONVALIDA_DATABINDING_R, Constants.CONVALIDA_DATABINDING_R}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("clearValidationsButton = ($T) button;", new Object[]{Constants.BUTTON}).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addCode("if (validateButton != null && clearValidationsButton != null) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("break;", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addCode("if (validateButton != null) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("validateOnClickListener(validateButton, target);", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode("\n", new Object[0]).addCode("if (clearValidationsButton != null) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("clearValidationsOnClickListener(clearValidationsButton, target);", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode("\n", new Object[0]).build();
    }

    private static CodeBlock createValidationsCodeBlock(ValidationClass validationClass) {
        CodeBlock.Builder builder = CodeBlock.builder();
        block28: for (ValidationField field : validationClass.fields) {
            block14 : switch (field.annotationClassName) {
                case "convalida.annotations.RequiredValidation": {
                    builder.add(JavaFiler.createRequiredValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.EmailValidation": {
                    builder.add(JavaFiler.createEmailValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.ConfirmEmailValidation": {
                    for (ValidationField validationField : validationClass.fields) {
                        if (!validationField.annotationClassName.equals("convalida.annotations.EmailValidation")) continue;
                        builder.add(JavaFiler.createConfirmEmailValidationCodeBlock(validationField, field));
                        break block14;
                    }
                    continue block28;
                }
                case "convalida.annotations.PatternValidation": {
                    builder.add(JavaFiler.createPatternValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.LengthValidation": {
                    builder.add(JavaFiler.createLengthValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.OnlyNumberValidation": {
                    builder.add(JavaFiler.createOnlyNumberValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.PasswordValidation": {
                    builder.add(JavaFiler.createPasswordValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.ConfirmPasswordValidation": {
                    for (ValidationField validationField : validationClass.fields) {
                        if (!validationField.annotationClassName.equals("convalida.annotations.PasswordValidation")) continue;
                        builder.add(JavaFiler.createConfirmPasswordValidationCodeBlock(validationField, field));
                        break block14;
                    }
                    continue block28;
                }
                case "convalida.annotations.CpfValidation": {
                    builder.add(JavaFiler.createCpfValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.BetweenValidation.Start": {
                    builder.add(JavaFiler.createBetweenValidationCodeBlock(validationClass, field));
                    break;
                }
                case "convalida.annotations.CreditCardValidation": {
                    builder.add(JavaFiler.createCreditCardValidationCodeBlock(field));
                    break;
                }
                case "convalida.annotations.NumberLimitValidation": {
                    builder.add(JavaFiler.createNumberLimitValidationCodeBlock(field));
                }
            }
        }
        return builder.build();
    }

    private static CodeBlock createRequiredValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $L))", new Object[]{Constants.REQUIRED_VALIDATOR, field.name, field.id.code, field.autoDismiss}).build();
    }

    private static CodeBlock createEmailValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $L, $L))", new Object[]{Constants.EMAIL_VALIDATOR, field.name, field.id.code, field.autoDismiss, field.element.getAnnotation(EmailValidation.class).required()}).build();
    }

    private static CodeBlock createConfirmEmailValidationCodeBlock(ValidationField emailField, ValidationField confirmEmailField) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.$N, target.getString($L), $L))", new Object[]{Constants.CONFIRM_EMAIL_VALIDATOR, emailField.name, confirmEmailField.name, confirmEmailField.id.code, confirmEmailField.autoDismiss}).build();
    }

    private static CodeBlock createPatternValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $S, $L, $L))", new Object[]{Constants.PATTERN_VALIDATOR, field.name, field.id.code, field.element.getAnnotation(PatternValidation.class).pattern(), field.autoDismiss, field.element.getAnnotation(PatternValidation.class).required()}).build();
    }

    private static CodeBlock createLengthValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, $L, $L, target.getString($L), $L, $L))", new Object[]{Constants.LENGTH_VALIDATOR, field.name, field.element.getAnnotation(LengthValidation.class).min(), field.element.getAnnotation(LengthValidation.class).max(), field.id.code, field.autoDismiss, field.element.getAnnotation(LengthValidation.class).required()}).build();
    }

    private static CodeBlock createOnlyNumberValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $L, $L))", new Object[]{Constants.ONLY_NUMBER_VALIDATOR, field.name, field.id.code, field.autoDismiss, field.element.getAnnotation(OnlyNumberValidation.class).required()}).build();
    }

    private static CodeBlock createPasswordValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, $L, $S, target.getString($L), $L))", new Object[]{Constants.PASSWORD_VALIDATOR, field.name, field.element.getAnnotation(PasswordValidation.class).min(), field.element.getAnnotation(PasswordValidation.class).pattern(), field.id.code, field.autoDismiss}).build();
    }

    private static CodeBlock createConfirmPasswordValidationCodeBlock(ValidationField passwordField, ValidationField confirmPasswordField) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.$N, target.getString($L), $L))", new Object[]{Constants.CONFIRM_PASSWORD_VALIDATOR, passwordField.name, confirmPasswordField.name, confirmPasswordField.id.code, confirmPasswordField.autoDismiss}).build();
    }

    private static CodeBlock createCpfValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $L, $L))", new Object[]{Constants.CPF_VALIDATOR, field.name, field.id.code, field.autoDismiss, field.element.getAnnotation(CpfValidation.class).required()}).build();
    }

    private static CodeBlock createBetweenValidationCodeBlock(ValidationClass validationClass, ValidationField startField) {
        ValidationField endField = null;
        for (ValidationField field : validationClass.fields) {
            if (!field.annotationClassName.equals("convalida.annotations.BetweenValidation.End")) continue;
            endField = field;
            break;
        }
        if (endField != null) {
            return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.$N, target.getString($L), target.getString($L), $L, $L))", new Object[]{Constants.BETWEEN_VALIDATOR, startField.name, endField.name, startField.id.code, endField.id.code, startField.autoDismiss, endField.autoDismiss}).build();
        }
        return CodeBlock.builder().build();
    }

    private static CodeBlock createCreditCardValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $L, $L))", new Object[]{Constants.CREDIT_CARD_VALIDATOR, field.name, field.id.code, field.autoDismiss, field.element.getAnnotation(CreditCardValidation.class).required()}).build();
    }

    private static CodeBlock createNumberLimitValidationCodeBlock(ValidationField field) {
        return CodeBlock.builder().addStatement("validatorSet.addValidator(new $T(target.$N, target.getString($L), $L, $S, $S, $L))", new Object[]{Constants.NUMBER_LIMIT_VALIDATOR, field.name, field.id.code, field.autoDismiss, field.element.getAnnotation(NumberLimitValidation.class).min(), field.element.getAnnotation(NumberLimitValidation.class).max(), field.element.getAnnotation(NumberLimitValidation.class).required()}).build();
    }

    private static CodeBlock createValidateOnClickCodeBlock(ValidationClass validationClass) {
        Element button = validationClass.getValidateButton();
        if (button != null) {
            return CodeBlock.builder().add("\n", new Object[0]).add("validateOnClickListener(target.$N, target);", new Object[]{button.getSimpleName().toString()}).build();
        }
        return CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private static CodeBlock createClearValidationsOnClickCodeBlock(ValidationClass validationClass) {
        Element button = validationClass.getClearValidationsButton();
        if (button != null) {
            return CodeBlock.builder().add("\n", new Object[0]).add("clearValidationsOnClickListener(target.$N, target);", new Object[]{button.getSimpleName().toString()}).add("\n", new Object[0]).build();
        }
        return CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private static MethodSpec createValidateOnClickListener(ValidationClass validationClass) {
        Element onValidationErrorMethod = validationClass.getOnValidationErrorMethod();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"validateOnClickListener").addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(Constants.UI_THREAD).addParameter(ParameterSpec.builder((TypeName)Constants.BUTTON, (String)"button", (Modifier[])new Modifier[0]).addAnnotation(Constants.NON_NULL).build()).addParameter(ParameterSpec.builder((TypeName)validationClass.typeName, (String)"target", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(Constants.NON_NULL).build()).addCode("button.setOnClickListener(new $T() {", new Object[]{Constants.VIEW_ONCLICK_LISTENER}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("@$T public void onClick($T view) {", new Object[]{Constants.OVERRIDE, Constants.VIEW}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("if(validatorSet.isValid()) {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("target.$N();", new Object[]{validationClass.getOnValidationSuccessMethod().getSimpleName()}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("}", new Object[0]);
        if (onValidationErrorMethod != null) {
            method.addCode(" else {", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("target.$N();", new Object[]{validationClass.getOnValidationErrorMethod().getSimpleName()}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("}", new Object[0]);
        }
        method.addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("}", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("\n", new Object[0]).addCode("});", new Object[0]).addCode("\n", new Object[0]);
        return method.build();
    }

    private static MethodSpec createClearValidationsOnClickListener(ValidationClass validationClass) {
        return MethodSpec.methodBuilder((String)"clearValidationsOnClickListener").addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(Constants.UI_THREAD).addParameter(ParameterSpec.builder((TypeName)Constants.BUTTON, (String)"button", (Modifier[])new Modifier[0]).addAnnotation(Constants.NON_NULL).build()).addParameter(ParameterSpec.builder((TypeName)validationClass.typeName, (String)"target", (Modifier[])new Modifier[0]).addAnnotation(Constants.NON_NULL).build()).addCode("button.setOnClickListener(new $T() {", new Object[]{Constants.VIEW_ONCLICK_LISTENER}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("@$T public void onClick($T view) {", new Object[]{Constants.OVERRIDE, Constants.VIEW}).addCode("\n", new Object[0]).addCode(CodeBlock.builder().indent().build()).addCode("validatorSet.clearValidators();", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("}", new Object[0]).addCode("\n", new Object[0]).addCode(CodeBlock.builder().unindent().build()).addCode("});", new Object[0]).addCode("\n", new Object[0]).build();
    }

    private static MethodSpec createInitMethod(ValidationClass validationClass) {
        ClassName className = ClassName.get((String)validationClass.packageName, (String)validationClass.className, (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(Constants.UI_THREAD).addParameter(ParameterSpec.builder((TypeName)validationClass.typeName, (String)"target", (Modifier[])new Modifier[0]).addAnnotation(Constants.NON_NULL).build()).addStatement("new $T(target)", new Object[]{className}).build();
    }

    private static MethodSpec createInitDatabindingMethod(ValidationClass validationClass) {
        ClassName className = ClassName.get((String)validationClass.packageName, (String)validationClass.className, (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(Constants.UI_THREAD).addParameter(ParameterSpec.builder((TypeName)validationClass.typeName, (String)"target", (Modifier[])new Modifier[0]).addAnnotation(Constants.NON_NULL).build()).addParameter(ParameterSpec.builder((TypeName)Constants.VIEW_DATA_BINDING, (String)"binding", (Modifier[])new Modifier[0]).addAnnotation(Constants.NON_NULL).build()).addStatement("new $T(target, binding)", new Object[]{className}).build();
    }
}

