/*
 * Decompiled with CFR 0.152.
 */
package com.next.easynavigation.utils;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.ArcShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.WindowManager;

public class NavigationUtil {
    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        int width = wm.getDefaultDisplay().getWidth();
        return width;
    }

    public static int getScreenHeith(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        int height = wm.getDefaultDisplay().getHeight();
        return height;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2ts(Context context, int isDp, float px) {
        if (isDp == 1) {
            return NavigationUtil.px2dip(context, px);
        }
        return NavigationUtil.px2sp(context, px);
    }

    public static void setRoundRectBg(Context mContext, View view, int dipRadius, int badgeColor) {
        int radius = NavigationUtil.dip2px(mContext, dipRadius);
        float[] radiusArray = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
        RoundRectShape roundRect = new RoundRectShape(radiusArray, null, null);
        ShapeDrawable bgDrawable = new ShapeDrawable((Shape)roundRect);
        bgDrawable.getPaint().setColor(badgeColor);
        view.setBackgroundDrawable((Drawable)bgDrawable);
    }

    public static void setOvalBg(View view, int bgColor) {
        ArcShape shape = new ArcShape(0.0f, 360.0f);
        ShapeDrawable drawable = new ShapeDrawable((Shape)shape);
        drawable.getPaint().setColor(bgColor);
        drawable.getPaint().setAntiAlias(true);
        drawable.getPaint().setStyle(Paint.Style.FILL);
        view.setBackgroundDrawable((Drawable)drawable);
    }

    public static float compareTo(Context context, float dimension, float tabTextSize, int textSizeType) {
        if (dimension == 0.0f) {
            return tabTextSize;
        }
        return NavigationUtil.px2ts(context, textSizeType, tabTextSize);
    }
}

