/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public class ActionsList<T> {
    protected Observable<List<T>> cache;
    protected final Evict<T> evict;
    boolean startToEvict;

    public ActionsList(Evict<T> evict, Observable<List<T>> cache) {
        this.evict = evict;
        this.cache = cache;
    }

    public static <T> ActionsList<T> with(Evict<T> evict, Observable<List<T>> cache) {
        return new ActionsList<T>(evict, cache);
    }

    public ActionsList<T> add(Func2 func2, T element) {
        return this.addAll(func2, Arrays.asList(element));
    }

    public ActionsList<T> addFirst(T element) {
        Func2 first = new Func2(){

            @Override
            public boolean call(int position, int count) {
                return position == 0;
            }
        };
        return this.addAll(first, Arrays.asList(element));
    }

    public ActionsList<T> addLast(T element) {
        Func2 last = new Func2(){

            @Override
            public boolean call(int position, int count) {
                return position == count;
            }
        };
        return this.addAll(last, Arrays.asList(element));
    }

    public ActionsList<T> addAllFirst(List<T> elements) {
        Func2 first = new Func2(){

            @Override
            public boolean call(int position, int count) {
                return position == 0;
            }
        };
        return this.addAll(first, elements);
    }

    public ActionsList<T> addAllLast(List<T> elements) {
        Func2 last = new Func2(){

            @Override
            public boolean call(int position, int count) {
                return position == count;
            }
        };
        return this.addAll(last, elements);
    }

    public ActionsList<T> addAll(final Func2 func2, final List<T> elements) {
        this.cache = this.cache.map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> items) {
                int count = items.size();
                for (int position = 0; position <= count; ++position) {
                    if (!func2.call(position, count)) continue;
                    items.addAll(position, elements);
                    break;
                }
                return items;
            }
        });
        return this;
    }

    public ActionsList<T> evictFirst() {
        Func3 first = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return position == 0;
            }
        };
        return this.evict(first);
    }

    public ActionsList<T> evictFirstN(int n) {
        return this.evictFirstN(new Func1Count(){

            @Override
            public boolean call(int count) {
                return true;
            }
        }, n);
    }

    public ActionsList<T> evictLast() {
        Func3 last = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return position == count - 1;
            }
        };
        return this.evict(last);
    }

    public ActionsList<T> evictLastN(int n) {
        return this.evictLastN(new Func1Count(){

            @Override
            public boolean call(int count) {
                return true;
            }
        }, n);
    }

    public ActionsList<T> evictFirst(final Func1Count func1Count) {
        Func3 firstPlusFunc1 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return position == 0 && func1Count.call(count);
            }
        };
        return this.evict(firstPlusFunc1);
    }

    public ActionsList<T> evictFirstN(final Func1Count func1Count, final int n) {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return position < n && func1Count.call(count);
            }
        };
        return this.evictIterable(func3);
    }

    public ActionsList<T> evictLast(final Func1Count func1Count) {
        Func3 lastPlusFunc1 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return position == count - 1 && func1Count.call(count);
            }
        };
        return this.evict(lastPlusFunc1);
    }

    public ActionsList<T> evictLastN(final Func1Count func1Count, final int n) {
        this.startToEvict = false;
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                if (!ActionsList.this.startToEvict) {
                    boolean bl = ActionsList.this.startToEvict = count - position == n;
                }
                if (ActionsList.this.startToEvict) {
                    return count - position <= n && func1Count.call(count);
                }
                return false;
            }
        };
        return this.evictIterable(func3);
    }

    public ActionsList<T> evict(final Func1Element<T> func1Element) {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return func1Element.call(element);
            }
        };
        return this.evict(func3);
    }

    public ActionsList<T> evict(final Func3<T> func3) {
        this.cache = this.cache.map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> elements) {
                int count = elements.size();
                for (int position = 0; position < count; ++position) {
                    if (!func3.call(position, count, elements.get(position))) continue;
                    elements.remove(position);
                    break;
                }
                return elements;
            }
        });
        return this;
    }

    public ActionsList<T> evictAll() {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return true;
            }
        };
        return this.evictIterable(func3);
    }

    public ActionsList<T> evictAllKeepingFirstN(final int n) {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                int positionToStartEvicting = count - (count - n);
                return position >= positionToStartEvicting;
            }
        };
        return this.evictIterable(func3);
    }

    public ActionsList<T> evictAllKeepingLastN(final int n) {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                int elementsToEvict = count - n;
                return position < elementsToEvict;
            }
        };
        return this.evictIterable(func3);
    }

    public ActionsList<T> evictIterable(final Func3<T> func3) {
        this.cache = this.cache.map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> elements) {
                int count = elements.size();
                for (int position = 0; position < count; ++position) {
                    if (!func3.call(position, count, elements.get(position))) continue;
                    elements.set(position, null);
                }
                elements.removeAll(Collections.singleton(null));
                return elements;
            }
        });
        return this;
    }

    public ActionsList<T> update(final Func1Element<T> func1Element, Replace<T> replace) {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return func1Element.call(element);
            }
        };
        return this.update(func3, replace);
    }

    public ActionsList<T> update(final Func3<T> func3, final Replace<T> replace) {
        this.cache = this.cache.map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> elements) {
                int count = elements.size();
                for (int position = 0; position < count; ++position) {
                    if (!func3.call(position, count, elements.get(position))) continue;
                    elements.set(position, replace.call(elements.get(position)));
                    break;
                }
                return elements;
            }
        });
        return this;
    }

    public ActionsList<T> updateIterable(final Func1Element<T> func1Element, Replace<T> replace) {
        Func3 func3 = new Func3<T>(){

            @Override
            public boolean call(int position, int count, T element) {
                return func1Element.call(element);
            }
        };
        return this.updateIterable(func3, replace);
    }

    public ActionsList<T> updateIterable(final Func3<T> func3, final Replace<T> replace) {
        this.cache = this.cache.map(new Func1<List<T>, List<T>>(){

            public List<T> call(List<T> elements) {
                int count = elements.size();
                for (int position = 0; position < count; ++position) {
                    if (!func3.call(position, count, elements.get(position))) continue;
                    elements.set(position, replace.call(elements.get(position)));
                }
                return elements;
            }
        });
        return this;
    }

    public Observable<List<T>> toObservable() {
        return this.evict.call(this.cache);
    }

    public static interface Replace<T> {
        public T call(T var1);
    }

    public static interface Func3<T> {
        public boolean call(int var1, int var2, T var3);
    }

    public static interface Func2 {
        public boolean call(int var1, int var2);
    }

    public static interface Func1Element<T> {
        public boolean call(T var1);
    }

    public static interface Func1Count {
        public boolean call(int var1);
    }

    public static interface Evict<T> {
        public Observable<List<T>> call(Observable<List<T>> var1);
    }
}

