/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache.internal;

import io.rx_cache.internal.ProxyProviders;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.InvalidParameterException;

public final class RxCache {
    private final Builder builder;

    private RxCache(Builder builder) {
        this.builder = builder;
    }

    public <T> T using(Class<T> classProviders) {
        ProxyProviders proxyProviders = new ProxyProviders(this.builder, classProviders);
        return (T)Proxy.newProxyInstance(classProviders.getClassLoader(), new Class[]{classProviders}, (InvocationHandler)proxyProviders);
    }

    public static class Builder {
        private boolean useExpiredDataIfLoaderNotAvailable;
        private Integer maxMBPersistenceCache;
        private File cacheDirectory;
        private JolyglotGenerics jolyglot;

        public Builder useExpiredDataIfLoaderNotAvailable(boolean useExpiredDataIfLoaderNotAvailable) {
            this.useExpiredDataIfLoaderNotAvailable = useExpiredDataIfLoaderNotAvailable;
            return this;
        }

        public Builder setMaxMBPersistenceCache(Integer maxMgPersistenceCache) {
            this.maxMBPersistenceCache = maxMgPersistenceCache;
            return this;
        }

        public RxCache persistence(File cacheDirectory, JolyglotGenerics jolyglot) {
            if (cacheDirectory == null) {
                throw new InvalidParameterException("File cache directory can not be null");
            }
            if (jolyglot == null) {
                throw new InvalidParameterException("JsonConverter can not be null");
            }
            this.cacheDirectory = cacheDirectory;
            this.jolyglot = jolyglot;
            return new RxCache(this);
        }

        public boolean useExpiredDataIfLoaderNotAvailable() {
            return this.useExpiredDataIfLoaderNotAvailable;
        }

        public Integer getMaxMBPersistenceCache() {
            return this.maxMBPersistenceCache;
        }

        public File getCacheDirectory() {
            return this.cacheDirectory;
        }

        public JolyglotGenerics getJolyglot() {
            return this.jolyglot;
        }
    }
}

