/*
 * Decompiled with CFR 0.152.
 */
package io.victoralbertos.jolyglot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import io.victoralbertos.jolyglot.Types;
import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JacksonSpeaker
implements JolyglotGenerics {
    private final ObjectMapper mapper;

    public JacksonSpeaker(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JacksonSpeaker() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String toJson(Object src) {
        try {
            return this.mapper.writeValueAsString(src);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson(Object src, Type typeOfSrc) {
        try {
            String json = this.mapper.writeValueAsString(src);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws RuntimeException {
        try {
            return (T)this.mapper.readValue(json, classOfT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String json, final Type typeOfT) throws RuntimeException {
        try {
            TypeReference referenceType = new TypeReference<T>(){

                public Type getType() {
                    return typeOfT;
                }
            };
            return (T)this.mapper.readValue(json, referenceType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(File file, Class<T> classOfT) throws RuntimeException {
        try {
            return (T)this.mapper.readValue(file, classOfT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(File file, final Type typeOfT) throws RuntimeException {
        try {
            TypeReference referenceType = new TypeReference<T>(){

                public Type getType() {
                    return typeOfT;
                }
            };
            Object object = this.mapper.readValue(file, referenceType);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GenericArrayType arrayOf(Type componentType) {
        return Types.arrayOf((Type)componentType);
    }

    public ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return Types.newParameterizedType((Type)rawType, (Type[])typeArguments);
    }
}

