/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ShortRandomCreator
implements DataCreator<Short> {
    private final int offset;
    private final int point;
    private final Random random;

    public ShortRandomCreator() {
        this(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public ShortRandomCreator(short min, short max) {
        this.offset = (max - min) / 2;
        this.point = (min + max) / 2;
        this.random = new Random();
    }

    @Override
    public List<Class<?>> types() {
        ArrayList list = new ArrayList();
        list.add(Short.class);
        list.add(Short.TYPE);
        return list;
    }

    @Override
    public Short mock(MockSrc src, MockDataCreator.Creator creator) {
        int ran = this.random.nextInt(this.offset);
        if (this.random.nextBoolean()) {
            return (short)(this.point - ran);
        }
        return (short)(this.point + ran);
    }
}

