/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LongRandomCreator
implements DataCreator<Long> {
    private final long offset;
    private final long point;
    private final Random random;

    public LongRandomCreator() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongRandomCreator(long min, long max) {
        this.offset = max / 2L - min / 2L;
        this.point = min / 2L + max / 2L;
        this.random = new Random();
    }

    @Override
    public List<Class<?>> types() {
        ArrayList list = new ArrayList();
        list.add(Long.class);
        list.add(Long.TYPE);
        return list;
    }

    @Override
    public Long mock(MockSrc src, MockDataCreator.Creator creator) {
        long num = (long)(this.random.nextDouble() * (double)this.offset);
        if (this.random.nextBoolean()) {
            return this.point - num;
        }
        return this.point + num;
    }
}

