/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Random;

public class LocalDateTimeCreator
implements DataCreator<LocalDateTime> {
    private static final int[] DAY_COUNT = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final int yearOffset;
    private final int yearPoint;
    private final Random random;

    public LocalDateTimeCreator() {
        this.yearOffset = 10;
        this.yearPoint = LocalDate.now().getYear() + this.yearOffset / 2;
        this.random = new Random();
    }

    @Override
    public LocalDateTime mock(MockSrc src, MockDataCreator.Creator creator) {
        int month = this.random.nextInt(12) + 1;
        LocalDate date = LocalDate.of(this.yearPoint - this.random.nextInt(this.yearOffset), month, this.random.nextInt(DAY_COUNT[month - 1]) + 1);
        LocalTime time = LocalTime.of(this.random.nextInt(24), this.random.nextInt(60));
        return LocalDateTime.of(date, time);
    }
}

