/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class IntegerRandomCreator
implements DataCreator<Integer> {
    private final int offset;
    private final int point;
    private final Random random;

    public IntegerRandomCreator() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerRandomCreator(int min, int max) {
        this.offset = max / 2 - min / 2;
        this.point = min / 2 + max / 2;
        this.random = new Random();
    }

    @Override
    public List<Class<?>> types() {
        ArrayList list = new ArrayList();
        list.add(Integer.class);
        list.add(Integer.TYPE);
        return list;
    }

    @Override
    public Integer mock(MockSrc src, MockDataCreator.Creator creator) {
        int ran = this.random.nextInt(this.offset);
        if (this.random.nextBoolean()) {
            return this.point - ran;
        }
        return this.point + ran;
    }
}

