/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class FloatRandomCreator
implements DataCreator<Float> {
    private final float offset;
    private final float point;
    private final Random random;

    public FloatRandomCreator() {
        this(Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public FloatRandomCreator(float min, float max) {
        this.offset = max / 2.0f - min / 2.0f;
        this.point = min / 2.0f + max / 2.0f;
        this.random = new Random();
    }

    @Override
    public List<Class<?>> types() {
        ArrayList list = new ArrayList();
        list.add(Float.class);
        list.add(Float.TYPE);
        return list;
    }

    @Override
    public Float mock(MockSrc src, MockDataCreator.Creator creator) {
        float num = this.random.nextFloat() * this.offset;
        if (this.random.nextBoolean()) {
            return Float.valueOf(this.point - num);
        }
        return Float.valueOf(this.point + num);
    }
}

