/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.creator.data;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.domain.MockSrc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DoubleRandomCreator
implements DataCreator<Double> {
    private final double offset;
    private final double point;
    private final Random random;

    public DoubleRandomCreator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleRandomCreator(double min, double max) {
        this.offset = max / 2.0 - min / 2.0;
        this.point = min / 2.0 + max / 2.0;
        this.random = new Random();
    }

    @Override
    public List<Class<?>> types() {
        ArrayList list = new ArrayList();
        list.add(Double.class);
        list.add(Double.TYPE);
        return list;
    }

    @Override
    public Double mock(MockSrc src, MockDataCreator.Creator creator) {
        double num = this.random.nextDouble() * this.offset;
        if (this.random.nextBoolean()) {
            return this.point - num;
        }
        return this.point + num;
    }
}

