/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.config.filter.impl;

import idea.verlif.mock.data.config.filter.FieldFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldModifierFilter
implements FieldFilter {
    private int modifiers = 2;

    public boolean isAllowPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public void setAllowPrivate(boolean allowPrivate) {
        this.modifiers = allowPrivate ? this.modifiers & 2 : this.modifiers ^ 2;
    }

    public boolean isAllowPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public void setAllowPublic(boolean allowPublic) {
        this.modifiers = allowPublic ? this.modifiers | 1 : this.modifiers ^ 1;
    }

    public boolean isAllowProtect() {
        return Modifier.isProtected(this.modifiers);
    }

    public void setAllowProtect(boolean allowProtect) {
        this.modifiers = allowProtect ? this.modifiers | 4 : this.modifiers ^ 4;
    }

    public boolean isAllowStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public void setAllowStatic(boolean allowStatic) {
        this.modifiers = allowStatic ? this.modifiers | 8 : this.modifiers ^ 8;
    }

    public void setAllowedModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public FieldModifierFilter allowedModifiers(int ... modifiers) {
        for (int modifier : modifiers) {
            this.modifiers |= modifier;
        }
        return this;
    }

    public FieldModifierFilter blockedModifiers(int ... modifiers) {
        for (int modifier : modifiers) {
            this.modifiers -= modifier;
        }
        return this;
    }

    public boolean isAllowedModifier(int mod) {
        return (mod & this.modifiers) != 0;
    }

    @Override
    public boolean accept(Object target, Field field) {
        return (field.getModifiers() | this.modifiers) == this.modifiers;
    }
}

