/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.config.filter.impl;

import idea.verlif.mock.data.config.filter.FieldFilter;
import idea.verlif.mock.data.util.ContainsUtil;
import idea.verlif.mock.data.util.NamingUtil;
import idea.verlif.reflection.domain.SFunction;
import idea.verlif.reflection.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class FieldKeyFilter
implements FieldFilter {
    private final Set<String> ignoredFiledSet = new HashSet<String>();
    private final List<Pattern> ignoredFiledPattern = new ArrayList<Pattern>();

    private <T> void addIgnoredField(SFunction<T, ?> function) {
        this.ignoredFiledSet.add(NamingUtil.getKeyName(ReflectUtil.getFieldFromLambda(function)));
    }

    public <T> FieldKeyFilter ignoredField(SFunction<T, ?> function) {
        this.addIgnoredField(function);
        return this;
    }

    private void addIgnoredField(Class<?> cla) {
        this.ignoredFiledSet.add(NamingUtil.getKeyName(cla));
    }

    public FieldKeyFilter ignoredField(Class<?> ... clas) {
        for (Class<?> cla : clas) {
            this.addIgnoredField(cla);
        }
        return this;
    }

    private void addIgnoredFieldRegex(String regex) {
        this.ignoredFiledPattern.add(Pattern.compile(regex));
    }

    public FieldKeyFilter ignoredFieldRegex(String ... regex) {
        for (String s : regex) {
            this.addIgnoredFieldRegex(s);
        }
        return this;
    }

    @Override
    public boolean accept(Object target, Field field) {
        return !ContainsUtil.checkContains(NamingUtil.getKeyName(field), this.ignoredFiledSet, this.ignoredFiledPattern) && !ContainsUtil.checkContains(NamingUtil.getKeyName(field.getType()), this.ignoredFiledSet, this.ignoredFiledPattern);
    }
}

