/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data.config;

import idea.verlif.mock.data.MockDataCreator;
import idea.verlif.mock.data.config.FieldDataPool;
import idea.verlif.mock.data.config.filter.ClassFilter;
import idea.verlif.mock.data.config.filter.FieldFilter;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.creator.DataFiller;
import idea.verlif.mock.data.creator.InstanceCreator;
import idea.verlif.mock.data.domain.MockSrc;
import idea.verlif.mock.data.exception.ClassNotMatchException;
import idea.verlif.mock.data.exception.MockDataException;
import idea.verlif.mock.data.util.ContainsUtil;
import idea.verlif.mock.data.util.NamingUtil;
import idea.verlif.reflection.domain.SFunction;
import idea.verlif.reflection.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;

public class CommonConfig {
    protected final Map<String, DataCreator<?>> fieldCreatorMap = new HashMap();
    protected final Map<Class<?>, DataCreator<?>> interfaceCreatorMap = new HashMap();
    protected final Map<String, InstanceCreator<?>> instanceCreatorMap = new HashMap();
    protected final Set<String> cascadeCreateSet = new HashSet<String>();
    protected final List<Pattern> cascadeCreatePattern = new ArrayList<Pattern>();
    protected final ArrayList<FieldFilter> fieldFilters = new ArrayList();
    protected final ArrayList<ClassFilter> classFilters = new ArrayList();
    protected FieldDataPool fieldDataPool;

    public <T> DataCreator<T> getDataCreator(String key) {
        return this.fieldCreatorMap.get(key);
    }

    protected <T> void addFieldValue(SFunction<T, ?> function, DataCreator<?> creator) {
        Field field = ReflectUtil.getFieldFromLambda(function);
        this.addFieldValue(NamingUtil.getKeyName(field), creator);
    }

    public <T> CommonConfig fieldValue(SFunction<T, ?> function, DataCreator<?> creator) {
        this.addFieldValue(function, creator);
        return this;
    }

    public <T> CommonConfig fieldValue(SFunction<T, ?> function, DataFiller<?> filler) {
        this.addFieldValue(function, filler);
        return this;
    }

    public <T> CommonConfig fieldValue(SFunction<T, ?> function, Object o) {
        this.addFieldValue(function, new StaticValueCreator(o));
        return this;
    }

    protected void addFieldValue(String key, DataCreator<?> creator) {
        this.fieldCreatorMap.put(key, creator);
    }

    public CommonConfig fieldValue(String key, DataCreator<?> creator) {
        this.addFieldValue(key, creator);
        return this;
    }

    protected void addFieldValue(Class<?> cla, DataCreator<?> creator) {
        String key = NamingUtil.getKeyName(cla);
        this.addFieldValue(key, creator);
    }

    protected void addFieldValue(DataCreator<?> creator) {
        if (creator.getClass().getName().contains("$Lambda")) {
            throw new MockDataException("Lambda expressions are not recognized!");
        }
        for (Class<?> cla : creator.types()) {
            this.addFieldValue(cla, creator);
        }
    }

    public <T> CommonConfig fieldValue(Class<T> cla, DataCreator<T> creator) {
        this.addFieldValue(cla, creator);
        return this;
    }

    public DataCreator<?> getInterfaceValue(Class<?> cla) {
        return this.interfaceCreatorMap.get(cla);
    }

    public CommonConfig interfaceValue(Class<?> cla, DataCreator<?> creator) {
        this.addInterfaceValue(cla, creator);
        return this;
    }

    protected void addInterfaceValue(Class<?> cla, DataCreator<?> filler) {
        if (!cla.isInterface()) {
            throw new ClassNotMatchException(cla + " is not interface!");
        }
        this.interfaceCreatorMap.put(cla, filler);
    }

    public <T> CommonConfig fieldValue(Class<T> cla, DataFiller<?> filler) {
        this.addFieldValue(cla, filler);
        return this;
    }

    public <T> CommonConfig fieldValue(Class<T> cla, Object o) {
        this.addFieldValue(cla, new StaticValueCreator(o));
        return this;
    }

    public CommonConfig fieldValue(DataCreator<?> creator) {
        this.addFieldValue(creator);
        return this;
    }

    public boolean hasFiledCreator(String key) {
        return this.fieldCreatorMap.containsKey(key);
    }

    protected void addInstanceCreator(InstanceCreator<?> creator) {
        Class<?> cla = creator.matched();
        if (cla != null) {
            this.instanceCreatorMap.put(NamingUtil.getKeyName(cla), creator);
        }
    }

    public CommonConfig instanceCreator(InstanceCreator<?> creator) {
        this.addInstanceCreator(creator);
        return this;
    }

    public <T> InstanceCreator<T> getInstanceCreator(Class<T> cla) {
        return this.instanceCreatorMap.get(NamingUtil.getKeyName(cla));
    }

    public CommonConfig cascadeCreateKey(Class<?> ... clas) {
        for (Class<?> cla : clas) {
            this.addCascadeCreateKey(NamingUtil.getKeyName(cla));
        }
        return this;
    }

    protected <T> void addCascadeCreateKey(SFunction<T, ?> function) {
        this.addCascadeCreateKey(NamingUtil.getKeyName(ReflectUtil.getFieldFromLambda(function)));
    }

    public <T> CommonConfig cascadeCreateKey(SFunction<T, ?> function) {
        this.addCascadeCreateKey(function);
        return this;
    }

    protected void addCascadeCreateKey(String key) {
        this.cascadeCreateSet.add(key);
    }

    public CommonConfig cascadeCreatePattern(String ... regex) {
        for (String s : regex) {
            this.addCascadeCreatePattern(s);
        }
        return this;
    }

    protected void addCascadeCreatePattern(String regex) {
        this.cascadeCreatePattern.add(Pattern.compile(regex));
    }

    public CommonConfig cascadeCreatePackage(String ... packName) {
        for (String s : packName) {
            this.addCascadeCreatePackage(s);
        }
        return this;
    }

    protected void addCascadeCreatePackage(String packName) {
        this.addCascadeCreatePattern(packName + ".*" + ".class");
    }

    public CommonConfig cascadeCreateKey(String key) {
        this.addCascadeCreateKey(key);
        return this;
    }

    public void removeCascadeCreateKey(Class<?> cla) {
        this.removeCascadeCreateKey(NamingUtil.getKeyName(cla));
    }

    public <T> void removeCascadeCreateKey(SFunction<T, ?> function) {
        this.removeCascadeCreateKey(NamingUtil.getKeyName(ReflectUtil.getFieldFromLambda(function)));
    }

    protected void removeCascadeCreateKey(String key) {
        this.cascadeCreateSet.remove(key);
    }

    public boolean isCascadeCreate(String key) {
        return ContainsUtil.checkContains(key, this.cascadeCreateSet, this.cascadeCreatePattern);
    }

    public CommonConfig filter(ClassFilter filter) {
        this.classFilters.add(filter);
        return this;
    }

    public CommonConfig filter(FieldFilter filter) {
        this.fieldFilters.add(filter);
        return this;
    }

    public void clearFieldFilter() {
        this.fieldFilters.clear();
    }

    public void clearClassFilter() {
        this.classFilters.clear();
    }

    public boolean isAllowedField(Object target, Field field) {
        for (FieldFilter filter : this.fieldFilters) {
            if (filter.accept(target, field)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowedClass(Class<?> cla) {
        for (ClassFilter filter : this.classFilters) {
            if (filter.accept(cla)) continue;
            return false;
        }
        return true;
    }

    public CommonConfig fieldDataPool(FieldDataPool pool) {
        this.fieldDataPool = pool;
        return this;
    }

    public <T> T randomDataFromDataPool(Class<?> cl, String key) {
        T[] values;
        if (this.fieldDataPool == null) {
            return null;
        }
        if (key == null) {
            key = "";
        }
        if ((values = this.fieldDataPool.getValues(cl, key)) == null || values.length == 0) {
            return null;
        }
        return values[new Random().nextInt(values.length)];
    }

    private static final class StaticValueCreator
    implements DataCreator<Object> {
        private final Object o;

        public StaticValueCreator(Object o) {
            this.o = o;
        }

        @Override
        public Object mock(MockSrc src, MockDataCreator.Creator creator) {
            return this.o;
        }
    }
}

