/*
 * Decompiled with CFR 0.152.
 */
package idea.verlif.mock.data;

import idea.verlif.mock.data.config.CommonConfig;
import idea.verlif.mock.data.config.MockDataConfig;
import idea.verlif.mock.data.creator.DataCreator;
import idea.verlif.mock.data.creator.InstanceCreator;
import idea.verlif.mock.data.creator.data.BigDecimalCreator;
import idea.verlif.mock.data.creator.data.BigIntegerCreator;
import idea.verlif.mock.data.creator.data.BooleanRandomCreator;
import idea.verlif.mock.data.creator.data.ByteRandomCreator;
import idea.verlif.mock.data.creator.data.CharacterRandomCreator;
import idea.verlif.mock.data.creator.data.DateRandomCreator;
import idea.verlif.mock.data.creator.data.DoubleRandomCreator;
import idea.verlif.mock.data.creator.data.EnumRandomCreator;
import idea.verlif.mock.data.creator.data.FloatRandomCreator;
import idea.verlif.mock.data.creator.data.IntegerRandomCreator;
import idea.verlif.mock.data.creator.data.ListCreator;
import idea.verlif.mock.data.creator.data.LocalDateCreator;
import idea.verlif.mock.data.creator.data.LocalDateTimeCreator;
import idea.verlif.mock.data.creator.data.LocalTimeCreator;
import idea.verlif.mock.data.creator.data.LongRandomCreator;
import idea.verlif.mock.data.creator.data.MapCreator;
import idea.verlif.mock.data.creator.data.SetCreator;
import idea.verlif.mock.data.creator.data.ShortRandomCreator;
import idea.verlif.mock.data.creator.data.StringRandomCreator;
import idea.verlif.mock.data.domain.MockSrc;
import idea.verlif.mock.data.domain.counter.StringCounter;
import idea.verlif.mock.data.util.NamingUtil;
import idea.verlif.reflection.domain.ClassGrc;
import idea.verlif.reflection.domain.FieldGrc;
import idea.verlif.reflection.domain.SFunction;
import idea.verlif.reflection.util.ReflectUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockDataCreator
extends CommonConfig {
    private MockDataConfig config = new MockDataConfig();

    public MockDataCreator() {
        this.useBaseData();
        this.useExtendData();
        this.useBaseFiller();
    }

    public void setConfig(MockDataConfig config) {
        this.config = config;
    }

    public MockDataConfig getConfig() {
        return this.config;
    }

    public void useBaseData() {
        this.addFieldValue(new ByteRandomCreator());
        this.addFieldValue(new BooleanRandomCreator());
        this.addFieldValue(new ShortRandomCreator());
        this.addFieldValue(new IntegerRandomCreator());
        this.addFieldValue(new LongRandomCreator());
        this.addFieldValue(new FloatRandomCreator());
        this.addFieldValue(new DoubleRandomCreator());
        this.addFieldValue(new CharacterRandomCreator());
        this.addFieldValue(new StringRandomCreator());
        this.addFieldValue(new DateRandomCreator());
        this.addFieldValue(new EnumRandomCreator());
    }

    public void useExtendData() {
        this.addFieldValue(new BigIntegerCreator());
        this.addFieldValue(new BigDecimalCreator());
        this.addFieldValue(new LocalDateCreator());
        this.addFieldValue(new LocalTimeCreator());
        this.addFieldValue(new LocalDateTimeCreator());
    }

    public void useBaseFiller() {
        this.addInterfaceValue(List.class, new ListCreator());
        this.addInterfaceValue(Map.class, new MapCreator());
        this.addInterfaceValue(Set.class, new SetCreator());
    }

    public <T, V> V mock(SFunction<T, V> function) {
        Method method = ReflectUtil.getMethodFromLambda(function);
        return (V)this.mock(method.getReturnType());
    }

    public <T> T mock(T t) {
        return this.mock(t, this.config);
    }

    public <T> T mock(T t, MockDataConfig config) {
        Creator creator = new Creator(config);
        creator.mock(t, ReflectUtil.getClassGrc(t.getClass()));
        creator.counterClear();
        return t;
    }

    public <T> T mock(Class<T> cla) {
        return this.mock(cla, this.config);
    }

    public <T> T mock(Class<T> cla, MockDataConfig config) {
        return this.mock(ReflectUtil.getClassGrc(cla), config);
    }

    public <T> T mock(ClassGrc classGrc) {
        return this.mock(classGrc, this.config);
    }

    public <T> T mock(ClassGrc classGrc, MockDataConfig config) {
        Creator creator = new Creator(config);
        Object t = creator.mockClass(classGrc);
        creator.counterClear();
        return t;
    }

    @Override
    public boolean isCascadeCreate(String key) {
        if (this.cascadeCreateSet.size() == 0 && this.cascadeCreatePattern.size() == 0) {
            return true;
        }
        return super.isCascadeCreate(key);
    }

    public final class Creator {
        private final StringCounter counter = new StringCounter(0);
        private final MockDataConfig mockConfig;

        public Creator(MockDataConfig config) {
            this.mockConfig = config;
        }

        public void counterClear() {
            this.counter.clearAll();
        }

        public MockDataConfig getMockConfig() {
            return this.mockConfig;
        }

        public <T> T mockClass(ClassGrc classGrc) {
            return this.mockSrc(new MockSrc(classGrc, null));
        }

        public <T> T mockSrc(MockSrc src) {
            Class cla = src.getClassGrc().getTarget();
            Object o = this.getObjectFromDataPool(cla, null);
            if (o == null) {
                Class<?> componentClass = this.getComponentClass(cla);
                if (this.isAllowedClass(componentClass)) {
                    Object t;
                    DataCreator<?> dataCreator = this.getDataCreator(cla);
                    if (dataCreator == null) {
                        t = this.newInstance(cla, new Object[0]);
                        String claKey = NamingUtil.getKeyName(componentClass);
                        if (this.isCascadeCreate(claKey)) {
                            this.mock(t, src.getClassGrc());
                        }
                    } else {
                        t = dataCreator.mock(src, this);
                    }
                    return (T)t;
                }
                return null;
            }
            return (T)o;
        }

        private <T> T mock(T t, ClassGrc classGrc) {
            Class cla = classGrc.getTarget();
            if (this.isAllowedClass(this.getComponentClass(cla))) {
                if (cla.isEnum()) {
                    return t;
                }
                if (cla.isArray()) {
                    this.fillArray(t, cla);
                } else {
                    try {
                        this.fillField(t, classGrc);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return t;
        }

        private void fillArray(Object o, Class<?> cla) {
            Class<?> componentType = cla.getComponentType();
            int size = Array.getLength(o);
            for (int i = 0; i < size; ++i) {
                if (componentType.isArray()) {
                    Class<?> realClaDepp = componentType.getComponentType();
                    Object arr = Array.get(o, i);
                    if (arr == null) {
                        int nextSize = this.mockConfig.getArraySize(this.getComponentClass(realClaDepp));
                        arr = Array.newInstance(realClaDepp, nextSize);
                    }
                    this.fillArray(arr, componentType);
                    Array.set(o, i, arr);
                    continue;
                }
                Array.set(o, i, this.mockClass(ReflectUtil.getClassGrc(componentType)));
            }
        }

        private void fillField(Object t, ClassGrc classGrc) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
            if (t == null) {
                return;
            }
            Class cla = classGrc.getTarget();
            Map genericsMap = ReflectUtil.getGenericsMap((ClassGrc)classGrc);
            List allFields = ReflectUtil.getAllFields((Class)cla);
            for (Field field : allFields) {
                Object o;
                FieldGrc fieldGrc = ReflectUtil.getFieldGrc((Field)field, (Map)genericsMap);
                Class fieldCla = fieldGrc.getTarget();
                Class<?> componentClass = this.getComponentClass(fieldCla);
                if (!this.isAllowedField(t, field) || !this.isAllowedClass(componentClass)) continue;
                String fieldKey = NamingUtil.getKeyName(field);
                String claKey = NamingUtil.getKeyName(componentClass);
                int max = this.getCreatingDepth(fieldKey, claKey);
                if (this.counter.getCount(fieldKey) >= max) continue;
                boolean oldAcc = field.isAccessible();
                if (!oldAcc) {
                    field.setAccessible(true);
                }
                try {
                    o = field.get(t);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (this.isAcceptField(o, field, fieldCla)) {
                    o = this.getObjectFromDataPool(fieldCla, field.getName());
                    if (o == null) {
                        int count = this.counter.count(fieldKey);
                        DataCreator<?> configCreator = this.getDataCreator(fieldGrc);
                        if (configCreator != null) {
                            o = configCreator.mock(new MockSrc((ClassGrc)fieldGrc, null), this);
                        } else {
                            o = this.newInstance(fieldCla, new Object[0]);
                            if (fieldCla.isArray()) {
                                this.fillArray(o, fieldCla);
                            } else if (this.isCascadeCreate(claKey) || this.isCascadeCreate(fieldKey)) {
                                this.fillField(o, (ClassGrc)fieldGrc);
                            }
                        }
                        this.counter.setCount(fieldKey, count - 1);
                    }
                    if (o != null) {
                        try {
                            field.set(t, o);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (oldAcc) continue;
                field.setAccessible(false);
            }
        }

        private int getCreatingDepth(String fieldKey, String claKey) {
            int defaultDepth = this.mockConfig.getCreatingDepth(null);
            int fieldDepth = this.mockConfig.getCreatingDepth(fieldKey);
            if (fieldDepth != defaultDepth) {
                return fieldDepth;
            }
            return this.mockConfig.getCreatingDepth(claKey);
        }

        private Class<?> getComponentClass(Class<?> arrayClass) {
            while (arrayClass.isArray()) {
                arrayClass = arrayClass.getComponentType();
            }
            return arrayClass;
        }

        private boolean isCascadeCreate(String key) {
            return MockDataCreator.this.isCascadeCreate(key) && this.mockConfig.isCascadeCreate(key);
        }

        private boolean isAllowedField(Object target, Field field) {
            return MockDataCreator.this.isAllowedField(target, field) && this.mockConfig.isAllowedField(target, field);
        }

        private boolean isAcceptField(Object fieldObject, Field field, Class<?> fieldCla) {
            if (this.mockConfig.getFieldOptions() == 0) {
                return true;
            }
            int options = (fieldObject == null ? 1 : 2) | (fieldCla.isPrimitive() ? 8 : 4);
            return this.mockConfig.acceptFieldOption(options);
        }

        private boolean isAllowedClass(Class<?> cla) {
            return MockDataCreator.this.isAllowedClass(cla) && this.mockConfig.isAllowedClass(cla);
        }

        public <T> T newInstance(Class<T> cla, Object ... params) {
            InstanceCreator<T> instanceCreator = this.getInstanceCreator(cla);
            if (instanceCreator == null) {
                if (cla.isArray()) {
                    return (T)Array.newInstance(cla.getComponentType(), this.mockConfig.getArraySize(this.getComponentClass(cla)));
                }
                try {
                    return (T)ReflectUtil.newInstance(cla, (Object[])params);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return instanceCreator.newInstance();
        }

        public <T> InstanceCreator<T> getInstanceCreator(Class<T> cla) {
            InstanceCreator<T> instanceCreator = this.mockConfig.getInstanceCreator(cla);
            if (instanceCreator == null) {
                instanceCreator = MockDataCreator.this.getInstanceCreator(cla);
            }
            return instanceCreator;
        }

        public DataCreator<?> getDataCreator(String key) {
            DataCreator creator = this.mockConfig.getDataCreator(key);
            if (creator == null) {
                creator = MockDataCreator.this.getDataCreator(key);
            }
            return creator;
        }

        public DataCreator<?> getInterfaceCreator(Class<?> cla) {
            DataCreator<?> creator = this.mockConfig.getInterfaceValue(cla);
            if (creator == null) {
                creator = MockDataCreator.this.getInterfaceValue(cla);
            }
            return creator;
        }

        public Object getObjectFromDataPool(Class<?> cl, String key) {
            Object o = this.mockConfig.randomDataFromDataPool(cl, key);
            if (o == null) {
                o = MockDataCreator.this.randomDataFromDataPool(cl, key);
            }
            return o;
        }

        public DataCreator<?> getDataCreator(Class<?> cla) {
            String key = NamingUtil.getKeyName(cla);
            DataCreator<?> creator = this.getDataCreator(key);
            if (creator == null) {
                if (cla.isEnum()) {
                    return this.getDataCreator(NamingUtil.getKeyName(cla.getSuperclass()));
                }
                block0: while (cla != null) {
                    Class<?>[] claInterfaces;
                    if (cla.isInterface()) {
                        return this.getInterfaceCreator(cla);
                    }
                    for (Class<?> anInterface : claInterfaces = cla.getInterfaces()) {
                        creator = this.getInterfaceCreator(anInterface);
                        if (anInterface != null) break block0;
                    }
                    cla = cla.getSuperclass();
                }
            }
            return creator;
        }

        public DataCreator<?> getDataCreator(FieldGrc fieldGrc) {
            DataCreator<?> creator = this.getDataCreator(NamingUtil.getKeyName(fieldGrc.getField()));
            if (creator != null) {
                return creator;
            }
            Class cla = fieldGrc.getTarget();
            return this.getDataCreator(cla);
        }
    }
}

