/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import nl.fountain.xelem.excel.Comment;
import nl.fountain.xelem.excel.XLElement;
import nl.fountain.xelem.excel.ss.SSCell;
import nl.fountain.xelem.lex.AnonymousBuilder;
import nl.fountain.xelem.lex.Director;
import nl.fountain.xelem.lex.ExcelReaderListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SSCellBuilder
extends AnonymousBuilder {
    private SSCell current;

    SSCellBuilder(Director director) {
        super(director);
    }

    @Override
    public void build(XMLReader reader, ContentHandler parent, XLElement xle) {
        this.setUpBuilder(reader, parent);
        this.current = (SSCell)xle;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.contents.reset();
        if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri)) {
            if ("Data".equals(localName)) {
                this.current.setAttributes(atts);
            } else if ("Comment".equals(localName)) {
                Comment comment = this.current.addComment();
                comment.setAttributes(atts);
                AnonymousBuilder builder = this.director.getAnonymousBuilder();
                builder.build(this.reader, this, comment);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.current.getNameSpace().equals(uri) && this.current.getTagName().equals(localName)) {
            for (ExcelReaderListener listener : this.director.getListeners()) {
                listener.setCell(this.director.getCurrentSheetIndex(), this.director.getCurrentSheetName(), this.director.getCurrentRowIndex(), this.current);
            }
            this.reader.setContentHandler(this.parent);
            return;
        }
        this.current.setChildElement(localName, this.contents.toString());
    }
}

