/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.Area;
import nl.fountain.xelem.XFactory;
import nl.fountain.xelem.XSerializer;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.Comment;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.ExcelWorkbook;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.Workbook;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.excel.ss.XLWorkbook;
import nl.fountain.xelem.lex.ExcelReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ExcelReaderTest
extends TestCase {
    String testOutputDir = "testoutput/ReaderTest/";
    boolean toFile = true;
    private static Workbook readerwb;

    public static void main(String[] args) {
        TestRunner.run(ExcelReaderTest.class);
    }

    public void testAdvise() {
        if (this.toFile) {
            System.out.println();
            System.out.println(((Object)((Object)this)).getClass() + " is writing files to: " + this.testOutputDir);
        }
    }

    public void testConstructor() throws Exception {
        ExcelReader reader = new ExcelReader();
        ExcelReaderTest.assertNotNull((Object)reader.getSaxParser());
        ExcelReaderTest.assertTrue((boolean)reader.getSaxParser().isNamespaceAware());
    }

    public void testConstructorWithGivenParser() throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        try {
            new ExcelReader(parser);
            ExcelReaderTest.fail((String)"is this parser namespace aware?");
        }
        catch (ParserConfigurationException e) {
            ExcelReaderTest.assertEquals((String)"cannot read with a parser that is unaware of namespaces.", (String)e.getMessage());
        }
    }

    public void testReadNoXML() throws Exception {
        ExcelReader reader = new ExcelReader();
        XMLReader xmlReader1 = reader.getSaxParser().getXMLReader();
        try {
            reader.getWorkbook("testsuitefiles/ReaderTest/excel.xls");
            ExcelReaderTest.fail((String)"should have thrown Exception");
        }
        catch (SAXParseException e) {
            ExcelReaderTest.assertEquals((int)1, (int)e.getLineNumber());
        }
        catch (Exception e2) {
            // empty catch block
        }
        Workbook wb = reader.getWorkbook("testsuitefiles/ReaderTest/reader.xml");
        XMLReader xmlReader2 = reader.getSaxParser().getXMLReader();
        ExcelReaderTest.assertSame((Object)xmlReader1, (Object)xmlReader2);
        this.doTestSheets(wb);
    }

    public void testReadInvalidXML() throws Exception {
        ExcelReader xlr = new ExcelReader();
        try {
            xlr.getWorkbook("testsuitefiles/ReaderTest/invalid.xml");
            ExcelReaderTest.fail((String)"should have thrown Exception");
        }
        catch (SAXParseException e) {
            ExcelReaderTest.assertEquals((int)11, (int)e.getLineNumber());
        }
    }

    public void testRead() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        ExcelReaderTest.assertNotNull((Object)wb);
        ExcelReaderTest.assertEquals((String)"reader", (String)wb.getName());
    }

    private Workbook getReaderWorkbook() throws Exception {
        if (readerwb == null) {
            ExcelReader reader = new ExcelReader();
            readerwb = reader.getWorkbook("testsuitefiles/ReaderTest/reader.xml");
        }
        return readerwb;
    }

    public void testReWrite() throws Exception {
        if (this.toFile) {
            ExcelReader xlr = new ExcelReader();
            Workbook wb = xlr.getWorkbook("testsuitefiles/ReaderTest/reader.xml");
            File out = new File(this.testOutputDir + "rewrite.xls");
            XSerializer xs = new XSerializer();
            xs.serialize(wb, out);
            wb = xlr.getWorkbook("testsuitefiles/ReaderTest/docprops.xml");
            out = new File(this.testOutputDir + "docprops_r.xls");
            xs.serialize(wb, out);
        }
    }

    public void testDocumentProperties() throws Exception {
        ExcelReader xlr = new ExcelReader();
        Workbook wb = xlr.getWorkbook("testsuitefiles/ReaderTest/docprops.xml");
        DocumentProperties props = wb.getDocumentProperties();
        ExcelReaderTest.assertEquals((long)1110888086000L, (long)props.getCreated().getTime());
        ExcelReaderTest.assertEquals((long)1110889149000L, (long)props.getLastSaved().getTime());
        ExcelReaderTest.assertEquals((long)1110979976000L, (long)props.getLastPrinted().getTime());
        ExcelReaderTest.assertEquals((String)"Title for docprops    ", (String)props.getTitle());
        ExcelReaderTest.assertEquals((String)"a test file", (String)props.getSubject());
        ExcelReaderTest.assertEquals((String)"ExcelReader                 tester", (String)props.getAuthor());
        ExcelReaderTest.assertEquals((String)"java xml bla bla", (String)props.getKeywords());
        char cr = '\r';
        char lf = '\n';
        ExcelReaderTest.assertEquals((String)("testing \ufffd \ufffd \ufffd \ufffd \ufffd documentproperties" + cr + lf + "more comments" + cr + lf + "and more..."), (String)props.getDescription());
        ExcelReaderTest.assertEquals((String)"Tom Poes", (String)props.getLastAuthor());
        ExcelReaderTest.assertNull((Object)props.getAppName());
        ExcelReaderTest.assertEquals((String)"NIWI-KNAW", (String)props.getCompany());
        ExcelReaderTest.assertEquals((String)"Asterix", (String)props.getManager());
        ExcelReaderTest.assertEquals((String)"foo", (String)props.getCategory());
        ExcelReaderTest.assertEquals((String)"http://xelem.sourceforge.net/", (String)props.getHyperlinkBase());
        ExcelReaderTest.assertEquals((String)"11.5703", (String)props.getVersion());
    }

    public void testExcelWorkbook() throws Exception {
        ExcelReader xlr = new ExcelReader();
        Workbook wb = xlr.getWorkbook("testsuitefiles/ReaderTest/excelworkbook.xml");
        ExcelWorkbook exw = wb.getExcelWorkbook();
        ExcelReaderTest.assertEquals((int)0, (int)exw.getActiveSheet());
        ExcelReaderTest.assertEquals((int)8835, (int)exw.getWindowHeight());
        ExcelReaderTest.assertEquals((int)120, (int)exw.getWindowTopX());
        ExcelReaderTest.assertEquals((int)90, (int)exw.getWindowTopY());
        ExcelReaderTest.assertEquals((int)15180, (int)exw.getWindowWidth());
        ExcelReaderTest.assertTrue((!exw.getProtectStructure() ? 1 : 0) != 0);
        ExcelReaderTest.assertTrue((boolean)exw.getProtectWindows());
    }

    public void testExcelWorkbook2() throws Exception {
        ExcelReader xlr = new ExcelReader();
        Workbook wb = xlr.getWorkbook("testsuitefiles/ReaderTest/excelworkbook2.xml");
        ExcelReaderTest.assertTrue((boolean)wb.hasExcelWorkbook());
        ExcelReaderTest.assertTrue((!wb.hasDocumentProperties() ? 1 : 0) != 0);
        Map<String, String> prfxs = xlr.getPrefixMap();
        ExcelReaderTest.assertEquals((String)"urn:schemas-microsoft-com:office:spreadsheet", (String)prfxs.get(""));
        ExcelReaderTest.assertEquals((String)"urn:schemas-microsoft-com:office:office", (String)prfxs.get("o"));
        ExcelReaderTest.assertEquals((String)"http://www.w3.org/TR/REC-html40", (String)prfxs.get("html"));
        ExcelReaderTest.assertEquals((String)"urn:schemas-microsoft-com:office:spreadsheet", (String)prfxs.get("ss"));
        ExcelReaderTest.assertEquals((String)"urn:schemas-microsoft-com:office:excel", (String)prfxs.get("x"));
    }

    public void testNamedRange() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Map<String, NamedRange> map = wb.getNamedRanges();
        ExcelReaderTest.assertEquals((int)1, (int)map.size());
        NamedRange nr = map.get("foo");
        ExcelReaderTest.assertEquals((String)"foo", (String)nr.getName());
        ExcelReaderTest.assertEquals((String)"='Tom Poes'!R9C4:R11C4", (String)nr.getRefersTo());
        ExcelReaderTest.assertTrue((!nr.isHidden() ? 1 : 0) != 0);
    }

    public void testWorksheet() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        this.doTestSheets(wb);
    }

    private void doTestSheets(Workbook wb) {
        Iterator<String> iter = wb.getSheetNames().iterator();
        ExcelReaderTest.assertEquals((String)"Tom Poes", (String)iter.next());
        ExcelReaderTest.assertEquals((String)"Donald Duck", (String)iter.next());
        ExcelReaderTest.assertEquals((String)"Asterix", (String)iter.next());
        ExcelReaderTest.assertEquals((String)"Sponge Bob", (String)iter.next());
        ExcelReaderTest.assertEquals((String)"window", (String)iter.next());
        try {
            iter.next();
            ExcelReaderTest.fail((String)"should be no next");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Worksheet sheet = wb.getWorksheet("Donald Duck");
        ExcelReaderTest.assertTrue((boolean)sheet.isProtected());
        sheet = wb.getWorksheet("Asterix");
        ExcelReaderTest.assertTrue((boolean)sheet.isRightToLeft());
        ExcelReaderTest.assertEquals((int)5, (int)wb.getSheetNames().size());
    }

    public void testGetWorksheetAt() throws Exception {
        Worksheet sheet;
        String[] sheetNames = new String[]{"Tom Poes", "Donald Duck", "Asterix", "Sponge Bob", "window"};
        Workbook wb = this.getReaderWorkbook();
        int i = 0;
        while ((sheet = wb.getWorksheetAt(i)) != null) {
            ExcelReaderTest.assertEquals((String)sheetNames[i++], (String)sheet.getName());
        }
        ExcelReaderTest.assertEquals((int)5, (int)i);
        ExcelReaderTest.assertNull((Object)wb.getWorksheetAt(i));
    }

    public void testNamedRangeOnWorksheet() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Worksheet sheet = wb.getWorksheet("Tom Poes");
        Map<String, NamedRange> map = sheet.getNamedRanges();
        ExcelReaderTest.assertEquals((int)1, (int)map.size());
        NamedRange nr = map.get("_FilterDatabase");
        ExcelReaderTest.assertEquals((String)"_FilterDatabase", (String)nr.getName());
        ExcelReaderTest.assertEquals((String)"='Tom Poes'!R8C4:R11C5", (String)nr.getRefersTo());
        ExcelReaderTest.assertTrue((boolean)nr.isHidden());
    }

    public void testTable() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Table table = wb.getWorksheet("Tom Poes").getTable();
        ExcelReaderTest.assertEquals((int)16, (int)table.getExpandedColumnCount());
        ExcelReaderTest.assertEquals((int)25, (int)table.getExpandedRowCount());
        ExcelReaderTest.assertEquals((String)"s22", (String)table.getStyleID());
    }

    public void testColumn() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Table table = wb.getWorksheet("Tom Poes").getTable();
        Column column1 = table.getColumnAt(1);
        ExcelReaderTest.assertEquals((String)"s23", (String)column1.getStyleID());
        ExcelReaderTest.assertTrue((!column1.getAutoFitWith() ? 1 : 0) != 0);
        ExcelReaderTest.assertEquals((int)0, (int)column1.getSpan());
        ExcelReaderTest.assertEquals((double)78.75, (double)column1.getWidth(), (double)0.0);
        Column column7 = table.getColumnAt(7);
        ExcelReaderTest.assertEquals((String)"s23", (String)column7.getStyleID());
        ExcelReaderTest.assertTrue((boolean)column7.getAutoFitWith());
        Column column9 = table.getColumnAt(9);
        ExcelReaderTest.assertEquals((int)1, (int)column9.getSpan());
        Column c9 = wb.getWorksheet("Tom Poes").getColumnAt("i");
        ExcelReaderTest.assertSame((Object)column9, (Object)c9);
        ExcelReaderTest.assertTrue((boolean)table.getColumnAt(16).isHidden());
        ExcelReaderTest.assertEquals((int)6, (int)table.getColumns().size());
    }

    public void testRow() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Table table = wb.getWorksheet("Tom Poes").getTable();
        ExcelReaderTest.assertTrue((!table.hasRowAt(1) ? 1 : 0) != 0);
        ExcelReaderTest.assertTrue((boolean)table.hasRowAt(3));
        Row row3 = table.getRowAt(3);
        ExcelReaderTest.assertEquals((String)"s25", (String)row3.getStyleID());
        ExcelReaderTest.assertEquals((double)27.0, (double)row3.getHeight(), (double)0.0);
        ExcelReaderTest.assertTrue((boolean)row3.isHidden());
        ExcelReaderTest.assertEquals((int)0, (int)row3.getSpan());
        ExcelReaderTest.assertTrue((boolean)table.hasRowAt(8));
        ExcelReaderTest.assertTrue((boolean)table.hasRowAt(9));
        ExcelReaderTest.assertTrue((boolean)table.hasRowAt(20));
        ExcelReaderTest.assertTrue((boolean)table.hasRowAt(22));
        ExcelReaderTest.assertEquals((int)13, (int)table.getRows().size());
    }

    public void testCell() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Table table = wb.getWorksheet("Tom Poes").getTable();
        Row row3 = table.getRowAt(3);
        ExcelReaderTest.assertTrue((boolean)row3.hasCellAt(1));
        Cell cell = row3.getCellAt(1);
        ExcelReaderTest.assertEquals((String)"String", (String)cell.getXLDataType());
        ExcelReaderTest.assertEquals((String)"blaadje 1", (String)cell.getData$());
        ExcelReaderTest.assertTrue((boolean)cell.hasData());
        ExcelReaderTest.assertTrue((!cell.hasError() ? 1 : 0) != 0);
        cell = table.getRowAt(6).getCellAt(2);
        ExcelReaderTest.assertEquals((String)"=R[-2]C[1]+R[-1]C[1]", (String)cell.getFormula());
        ExcelReaderTest.assertEquals((String)"Number", (String)cell.getXLDataType());
        ExcelReaderTest.assertEquals((String)"0", (String)cell.getData$());
        cell = table.getRowAt(10).getCellAt(2);
        ExcelReaderTest.assertEquals((String)"=5/R[-4]C", (String)cell.getFormula());
        ExcelReaderTest.assertEquals((String)"Error", (String)cell.getXLDataType());
        ExcelReaderTest.assertEquals((String)"#DIV/0!", (String)cell.getData$());
        ExcelReaderTest.assertTrue((boolean)cell.hasData());
        ExcelReaderTest.assertTrue((boolean)cell.hasError());
        cell = table.getRowAt(20).getCellAt(2);
        ExcelReaderTest.assertEquals((int)1, (int)cell.getMergeAcross());
        ExcelReaderTest.assertEquals((int)5, (int)cell.getMergeDown());
        ExcelReaderTest.assertEquals((String)"foo", (String)cell.getData$());
        ExcelReaderTest.assertTrue((boolean)cell.hasData());
        ExcelReaderTest.assertEquals((String)"#foo", (String)cell.getHRef());
    }

    public void testCellValues() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Worksheet sheet = wb.getWorksheet("Tom Poes");
        Cell cell = sheet.getCellAt(8, 9);
        ExcelReaderTest.assertTrue((boolean)cell.booleanValue());
        Boolean boo = (Boolean)cell.getData();
        ExcelReaderTest.assertTrue((boolean)boo);
        ExcelReaderTest.assertEquals((int)1, (int)cell.intValue());
        ExcelReaderTest.assertEquals((double)1.0, (double)cell.doubleValue(), (double)0.0);
        cell = sheet.getCellAt(9, 9);
        ExcelReaderTest.assertFalse((boolean)cell.booleanValue());
        boo = (Boolean)cell.getData();
        ExcelReaderTest.assertFalse((boolean)boo);
        ExcelReaderTest.assertEquals((int)0, (int)cell.intValue());
        ExcelReaderTest.assertEquals((double)0.0, (double)cell.doubleValue(), (double)0.0);
        cell = sheet.getCellAt(10, 9);
        ExcelReaderTest.assertFalse((boolean)cell.booleanValue());
        ExcelReaderTest.assertEquals((int)0, (int)cell.intValue());
        Date date = (Date)cell.getData();
        ExcelReaderTest.assertEquals((long)1112306400000L, (long)date.getTime());
        cell = sheet.getCellAt(11, 9);
        date = (Date)cell.getData();
        ExcelReaderTest.assertEquals((long)-2209033800000L, (long)date.getTime());
        ExcelReaderTest.assertEquals((String)"1899-12-31T12:30:00.000", (String)cell.getData$());
        cell = sheet.getCellAt(12, 9);
        ExcelReaderTest.assertEquals((int)1, (int)cell.intValue());
        ExcelReaderTest.assertEquals((double)1.234, (double)cell.doubleValue(), (double)0.0);
        ExcelReaderTest.assertFalse((boolean)cell.booleanValue());
        cell = sheet.getCellAt(13, 9);
        Double doo = (Double)cell.getData();
        ExcelReaderTest.assertEquals((int)5, (int)doo.intValue());
        ExcelReaderTest.assertEquals((double)5.0, (double)cell.doubleValue(), (double)0.0);
        ExcelReaderTest.assertEquals((int)5, (int)cell.intValue());
        cell = sheet.getCellAt(14, 9);
        ExcelReaderTest.assertEquals((Object)"#NAME?", (Object)cell.getData());
        cell = sheet.getCellAt(15, 9);
        ExcelReaderTest.assertEquals((Object)"xelem", (Object)cell.getData());
    }

    public void testWorksheetOptions() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Worksheet sheet = wb.getWorksheet("Tom Poes");
        ExcelReaderTest.assertTrue((boolean)sheet.hasWorksheetOptions());
        WorksheetOptions wso = sheet.getWorksheetOptions();
        ExcelReaderTest.assertTrue((boolean)wso.isSelected());
        ExcelReaderTest.assertEquals((int)6, (int)wso.getTopRowVisible());
        ExcelReaderTest.assertEquals((int)1, (int)wso.getLeftColumnVisible());
        ExcelReaderTest.assertEquals((int)75, (int)wso.getZoom());
        ExcelReaderTest.assertEquals((int)-1, (int)wso.getTabColorIndex());
        ExcelReaderTest.assertTrue((!wso.displaysNoHeadings() ? 1 : 0) != 0);
        ExcelReaderTest.assertTrue((!wso.displaysNoGridlines() ? 1 : 0) != 0);
        ExcelReaderTest.assertTrue((!wso.displaysFormulas() ? 1 : 0) != 0);
        ExcelReaderTest.assertEquals((String)"SheetVisible", (String)wso.getVisible());
        ExcelReaderTest.assertNull((Object)wso.getGridlineColor());
        sheet = wb.getWorksheet("Donald Duck");
        wso = sheet.getWorksheetOptions();
        ExcelReaderTest.assertTrue((!wso.isSelected() ? 1 : 0) != 0);
        ExcelReaderTest.assertTrue((boolean)wso.displaysNoHeadings());
        ExcelReaderTest.assertTrue((boolean)wso.displaysNoGridlines());
        sheet = wb.getWorksheet("Asterix");
        wso = sheet.getWorksheetOptions();
        ExcelReaderTest.assertTrue((!wso.isSelected() ? 1 : 0) != 0);
        ExcelReaderTest.assertEquals((int)12, (int)wso.getTabColorIndex());
        ExcelReaderTest.assertTrue((boolean)wso.displaysFormulas());
        ExcelReaderTest.assertEquals((String)"#FF0000", (String)wso.getGridlineColor());
        sheet = wb.getWorksheet("Sponge Bob");
        wso = sheet.getWorksheetOptions();
        ExcelReaderTest.assertEquals((String)"SheetHidden", (String)wso.getVisible());
    }

    public void testAutoFilter() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Worksheet sheet = wb.getWorksheet("Tom Poes");
        ExcelReaderTest.assertTrue((boolean)sheet.hasAutoFilter());
        sheet = wb.getWorksheet("Sponge Bob");
        ExcelReaderTest.assertTrue((!sheet.hasAutoFilter() ? 1 : 0) != 0);
    }

    public void testComment() throws Exception {
        Workbook wb = this.getReaderWorkbook();
        Worksheet sheet = wb.getWorksheet("Tom Poes");
        Cell cell = sheet.getCellAt(16, 5);
        ExcelReaderTest.assertTrue((boolean)cell.hasComment());
        Comment comment = cell.getComment();
        ExcelReaderTest.assertTrue((boolean)comment.showsAlways());
        ExcelReaderTest.assertEquals((String)"WF Hermans", (String)comment.getAuthor());
        char lf = '\n';
        ExcelReaderTest.assertEquals((String)("WF Hermans:" + lf + "this is comment"), (String)comment.getData());
        ExcelReaderTest.assertEquals((String)"this is comment", (String)comment.getDataClean());
    }

    public void testPartialRead() throws Exception {
        ExcelReader xlr = new ExcelReader();
        Area area = new Area("E11:M16");
        xlr.setReadArea(area);
        Workbook wb = xlr.getWorkbook("testsuitefiles/ReaderTest/reader.xml");
        Worksheet sheet = wb.getWorksheetAt(0);
        ExcelReaderTest.assertFalse((boolean)sheet.hasColumnAt("A"));
        ExcelReaderTest.assertTrue((boolean)sheet.hasColumnAt("G"));
        ExcelReaderTest.assertFalse((boolean)sheet.hasRowAt(10));
        ExcelReaderTest.assertTrue((boolean)sheet.hasRowAt(11));
        ExcelReaderTest.assertTrue((boolean)sheet.hasRowAt(16));
        ExcelReaderTest.assertFalse((boolean)sheet.hasRowAt(20));
        ExcelReaderTest.assertEquals((Object)"c", (Object)sheet.getCellAt("E11").getData());
        Date date = (Date)sheet.getCellAt("I11").getData();
        ExcelReaderTest.assertEquals((long)-2209033800000L, (long)date.getTime());
        int i = 0;
        while ((sheet = wb.getWorksheetAt(i++)) != null) {
            if (!sheet.getWorksheetOptions().hasSplit()) {
                sheet.getWorksheetOptions().setRangeSelection(area);
                sheet.getWorksheetOptions().setActiveCell(14, 8);
                sheet.addCellAt(1, 1).setData("only the selected area has been read");
                continue;
            }
            sheet.addCellAt(1, 1).setData("only " + area.getA1Reference() + " has been read");
        }
        if (this.toFile) {
            File out = new File(this.testOutputDir + "partial.xls");
            new XSerializer().serialize(wb, out);
        }
    }

    public void testStream() throws Exception {
        PipedReader inA = new PipedReader();
        PrintWriter outA = new PrintWriter(new PipedWriter(inA));
        PipedWriter outB = new PipedWriter();
        BufferedReader inB = new BufferedReader(new PipedReader(outB));
        Transmittor transmittor = new Transmittor(inA, outB);
        transmittor.start();
        Reciever reciever = new Reciever(inB);
        reciever.start();
        XLWorkbook wb = new XLWorkbook("foo");
        Worksheet sheet = wb.addSheet("bar");
        sheet.setAutoFilter(new Area("C5:F5").getAbsoluteRange());
        sheet.addCell("transmitted with \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0722\ufffd\ufffd?\ufffd\ufffd");
        wb.appendInfoSheet();
        new XSerializer().serialize((Workbook)wb, (Writer)outA);
        outA.flush();
        outA.close();
        while (reciever.isAlive()) {
        }
        while (transmittor.isAlive()) {
        }
    }

    private class Reciever
    extends Thread {
        private Reader in;

        public Reciever(Reader in) {
            this.in = in;
            this.setName("recieverThread");
        }

        @Override
        public void run() {
            try {
                InputSource source = new InputSource(this.in);
                ExcelReader reader = new ExcelReader();
                Workbook wb = reader.getWorkbook(source);
                this.in.close();
                XFactory.reset();
                TestCase.assertEquals((String)"source", (String)wb.getFileName());
                TestCase.assertEquals((String)"source", (String)wb.getName());
                TestCase.assertEquals((Object)"transmitted with \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0722\ufffd\ufffd?\ufffd\ufffd", (Object)wb.getWorksheetAt(0).getCellAt(1, 1).getData());
                if (ExcelReaderTest.this.toFile) {
                    wb.addElementComment(" this workbook was recieved at " + new Date() + " ");
                    wb.setFileName(ExcelReaderTest.this.testOutputDir + "transmitted.xls");
                    new XSerializer().serialize(wb);
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (XelemException e) {
                e.printStackTrace();
            }
        }
    }

    private class Transmittor
    extends Thread {
        private Reader in;
        private Writer out;

        public Transmittor(Reader in, Writer out) {
            this.in = in;
            this.out = out;
            this.setName("transmittorThread");
        }

        @Override
        public void run() {
            try {
                int i;
                while ((i = this.in.read()) > -1) {
                    this.out.write(i);
                    this.out.flush();
                }
                this.in.close();
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

