/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.fountain.xelem.excel.AutoFilter;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.ExcelWorkbook;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.lex.ExcelReaderFilter;
import nl.fountain.xelem.lex.ExcelReaderListener;

public class DefaultExcelReaderFilter
implements ExcelReaderFilter {
    private List<ExcelReaderListener> listeners;

    @Override
    public List<ExcelReaderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ExcelReaderListener>();
        }
        return this.listeners;
    }

    @Override
    public void addExcelReaderListener(ExcelReaderListener listener) {
        if (!this.getListeners().contains(listener)) {
            this.getListeners().add(listener);
        }
    }

    @Override
    public boolean removeExcelReaderListener(ExcelReaderListener listener) {
        return this.getListeners().remove(listener);
    }

    @Override
    public void clearExcelReaderListeners() {
        this.getListeners().clear();
    }

    @Override
    public void startDocument() {
        for (ExcelReaderListener l : this.getListeners()) {
            l.startDocument();
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.processingInstruction(target, data);
        }
    }

    @Override
    public void startWorkbook(String systemID) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.startWorkbook(systemID);
        }
    }

    @Override
    public void setDocumentProperties(DocumentProperties docProps) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setDocumentProperties(docProps);
        }
    }

    @Override
    public void setExcelWorkbook(ExcelWorkbook excelWb) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setExcelWorkbook(excelWb);
        }
    }

    @Override
    public void setNamedRange(NamedRange namedRange) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setNamedRange(namedRange);
        }
    }

    @Override
    public void startWorksheet(int sheetIndex, Worksheet sheet) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.startWorksheet(sheetIndex, sheet);
        }
    }

    @Override
    public void setNamedRange(int sheetIndex, String sheetName, NamedRange namedRange) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setNamedRange(sheetIndex, sheetName, namedRange);
        }
    }

    @Override
    public void startTable(int sheetIndex, String sheetName, Table table) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.startTable(sheetIndex, sheetName, table);
        }
    }

    @Override
    public void setColumn(int sheetIndex, String sheetName, Column column) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setColumn(sheetIndex, sheetName, column);
        }
    }

    @Override
    public void setRow(int sheetIndex, String sheetName, Row row) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setRow(sheetIndex, sheetName, row);
        }
    }

    @Override
    public void setCell(int sheetIndex, String sheetName, int rowIndex, Cell cell) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setCell(sheetIndex, sheetName, rowIndex, cell);
        }
    }

    @Override
    public void setWorksheetOptions(int sheetIndex, String sheetName, WorksheetOptions wsOptions) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setWorksheetOptions(sheetIndex, sheetName, wsOptions);
        }
    }

    @Override
    public void setAutoFilter(int sheetIndex, String sheetName, AutoFilter autoFilter) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.setAutoFilter(sheetIndex, sheetName, autoFilter);
        }
    }

    @Override
    public void endWorksheet(int sheetIndex, String sheetName) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.endWorksheet(sheetIndex, sheetName);
        }
    }

    @Override
    public void endDocument(Map<String, String> prefixMap) {
        for (ExcelReaderListener l : this.getListeners()) {
            l.endDocument(prefixMap);
        }
    }
}

