/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.io.CharArrayWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.ExcelWorkbook;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.excel.XLElement;
import nl.fountain.xelem.lex.Builder;
import nl.fountain.xelem.lex.Director;
import nl.fountain.xelem.lex.ExcelReaderListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class AnonymousBuilder
extends DefaultHandler
implements Builder {
    private static Map<String, Method> methodMap;
    private boolean occupied;
    protected XMLReader reader;
    protected ContentHandler parent;
    protected Director director;
    protected CharArrayWriter contents;
    protected XLElement current;

    protected AnonymousBuilder(Director director) {
        this.director = director;
        this.contents = new CharArrayWriter();
    }

    @Override
    public void build(XMLReader reader, ContentHandler parent, XLElement xle) {
        this.setUpBuilder(reader, parent);
        this.current = xle;
    }

    @Override
    public void build(XMLReader reader, ContentHandler parent) {
        this.setUpBuilder(reader, parent);
    }

    protected void setUpBuilder(XMLReader reader, ContentHandler parent) {
        this.reader = reader;
        this.parent = parent;
        reader.setContentHandler(this);
    }

    protected void setOccupied(boolean b) {
        this.occupied = b;
    }

    protected boolean isOccupied() {
        return this.occupied;
    }

    private Method getMethod(String tagName) {
        return this.getMethodMap().get(tagName);
    }

    private Map<String, Method> getMethodMap() {
        if (methodMap == null) {
            methodMap = new HashMap<String, Method>();
            Object[][] methods = null;
            try {
                methods = new Object[][]{{"DocumentProperties", ExcelReaderListener.class.getMethod("setDocumentProperties", DocumentProperties.class)}, {"ExcelWorkbook", ExcelReaderListener.class.getMethod("setExcelWorkbook", ExcelWorkbook.class)}, {"WorksheetOptions", ExcelReaderListener.class.getMethod("setWorksheetOptions", Integer.TYPE, String.class, WorksheetOptions.class)}};
                for (int i = 0; i < methods.length; ++i) {
                    methodMap.put((String)methods[i][0], (Method)methods[i][1]);
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return methodMap;
    }

    private void informListeners() {
        Method m;
        if (this.director.getListeners().size() > 0 && (m = this.getMethod(this.current.getTagName())) != null) {
            try {
                for (ExcelReaderListener listener : this.director.getListeners()) {
                    if (m.getParameterTypes()[0].equals(Integer.TYPE)) {
                        m.invoke((Object)listener, new Integer(this.director.getCurrentSheetIndex()), this.director.getCurrentSheetName(), this.current);
                        continue;
                    }
                    m.invoke((Object)listener, this.current);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://www.w3.org/TR/REC-html40".equals(uri)) {
            this.contents.reset();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.current.getNameSpace().equals(uri) && this.current.getTagName().equals(localName)) {
            this.informListeners();
            this.reader.setContentHandler(this.parent);
            this.occupied = false;
            return;
        }
        this.current.setChildElement(localName, this.contents.toString());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }
}

