/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.expat;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import nl.fountain.xelem.Address;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Row;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XLDocument {
    private Document doc;
    private Map<String, Node> tableMap;

    public XLDocument(String fileName) throws XelemException {
        this.doc = this.loadDocument(fileName);
        this.tableMap = new HashMap<String, Node>();
    }

    public Document getDocument() {
        return this.doc;
    }

    public void appendRow(String sheetName, Row row) {
        Element rowElement = row.createElement(this.doc);
        this.getTableElement(sheetName).appendChild(rowElement);
    }

    public void appendRows(String sheetName, Collection<Row> rows) {
        Element table = this.getTableElement(sheetName);
        Iterator<Row> iter = rows.iterator();
        while (iter.hasNext()) {
            table.appendChild(iter.next().createElement(this.doc));
        }
    }

    public void setCellData(Cell cell, String sheetName, int rowIndex, int columnIndex) {
        Element data = cell.getDataElement(this.doc);
        Element cellElement = this.getCellElement(sheetName, rowIndex, columnIndex);
        NodeList nodelist = cellElement.getChildNodes();
        Node oldData = null;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            if (!"Data".equals(nodelist.item(i).getLocalName())) continue;
            oldData = nodelist.item(i);
        }
        if (oldData == null) {
            cellElement.appendChild(data);
        } else {
            cellElement.replaceChild(data, oldData);
        }
    }

    public int setPTSourceFileName(String fileName) {
        int n = 0;
        NodeList nodelist = this.doc.getElementsByTagName("FileName");
        if (nodelist.getLength() == 0) {
            nodelist = this.doc.getElementsByTagNameNS("urn:schemas-microsoft-com:office:excel", "FileName");
        }
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node fileNameElement = nodelist.item(i);
            Node oldTekst = fileNameElement.getFirstChild();
            Text newTekst = this.doc.createTextNode(fileName);
            fileNameElement.replaceChild(newTekst, oldTekst);
            ++n;
        }
        return n;
    }

    public int setPTSourceFileName(String fileName, String sheetName) {
        return this.setPTSourceFileName("[" + fileName + "]" + sheetName);
    }

    public int setPTSourceReference(String reference) {
        int n = 0;
        NodeList nodelist = this.doc.getElementsByTagName("Reference");
        if (nodelist.getLength() == 0) {
            nodelist = this.doc.getElementsByTagNameNS("urn:schemas-microsoft-com:office:excel", "Reference");
        }
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node element = nodelist.item(0);
            Node oldTekst = element.getFirstChild();
            Text newTekst = this.doc.createTextNode(reference);
            element.replaceChild(newTekst, oldTekst);
            ++n;
        }
        return n;
    }

    public int setPTSourceReference(Address address1, Address address2) {
        String ref = address1.getAbsoluteRange(address2);
        return this.setPTSourceReference(ref);
    }

    public int setPTSourceReference(int r1, int c1, int r2, int c2) {
        return this.setPTSourceReference(new Address(r1, c1).getAbsoluteRange(r2, c2));
    }

    protected Element getSheetElement(String sheetName) {
        NodeList nodelist = this.doc.getElementsByTagName("Worksheet");
        if (nodelist.getLength() == 0) {
            nodelist = this.doc.getElementsByTagNameNS("urn:schemas-microsoft-com:office:spreadsheet", "Worksheet");
        }
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node sheetNode = nodelist.item(i);
            NamedNodeMap atrbs = sheetNode.getAttributes();
            Node nameAtrb = atrbs.getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "Name");
            if (nameAtrb == null || !sheetName.equals(nameAtrb.getNodeValue())) continue;
            return (Element)sheetNode;
        }
        throw new NoSuchElementException("The worksheet '" + sheetName + "' does not exist.");
    }

    protected Element getTableElement(String sheetName) {
        Element tableElement = (Element)this.tableMap.get(sheetName);
        if (tableElement == null) {
            Element sheet = this.getSheetElement(sheetName);
            NodeList sheetKits = sheet.getChildNodes();
            for (int i = 0; i < sheetKits.getLength(); ++i) {
                Node node = sheetKits.item(i);
                if (!"Table".equals(node.getLocalName())) continue;
                NamedNodeMap atrbs = node.getAttributes();
                if (atrbs.getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ExpandedColumnCount") != null) {
                    atrbs.removeNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ExpandedColumnCount");
                }
                if (atrbs.getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ExpandedRowCount") != null) {
                    atrbs.removeNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ExpandedRowCount");
                }
                this.tableMap.put(sheetName, node);
                return (Element)node;
            }
            if (tableElement == null) {
                tableElement = this.doc.createElementNS("urn:schemas-microsoft-com:office:spreadsheet", "Table");
                sheet.appendChild(tableElement);
                this.tableMap.put(sheetName, tableElement);
            }
        }
        return tableElement;
    }

    protected Element getCellElement(String sheetName, int rowIndex, int columnIndex) {
        Element row = this.getRowElement(sheetName, rowIndex);
        NodeList nodelist = row.getChildNodes();
        int teller = 0;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (!"Cell".equals(node.getLocalName())) continue;
            ++teller;
            Node idx = node.getAttributes().getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "Index");
            if (idx != null) {
                teller = Integer.parseInt(idx.getNodeValue());
            }
            if (teller == columnIndex) {
                return (Element)node;
            }
            if (teller <= columnIndex) continue;
            Element cellElement = this.createIndexedElement("Cell", columnIndex);
            row.insertBefore(cellElement, node);
            return cellElement;
        }
        Element cellElement = this.createIndexedElement("Cell", columnIndex);
        row.appendChild(cellElement);
        return cellElement;
    }

    protected Element getRowElement(String sheetName, int index) {
        Element table = this.getTableElement(sheetName);
        NodeList nodelist = table.getChildNodes();
        int teller = 0;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (!"Row".equals(node.getLocalName())) continue;
            ++teller;
            Node idx = node.getAttributes().getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "Index");
            if (idx != null) {
                teller = Integer.parseInt(idx.getNodeValue());
            }
            if (teller == index) {
                return (Element)node;
            }
            if (teller <= index) continue;
            Element rowElement = this.createIndexedElement("Row", index);
            table.insertBefore(rowElement, node);
            return rowElement;
        }
        Element rowElement = this.createIndexedElement("Row", index);
        table.appendChild(rowElement);
        return rowElement;
    }

    private Element createIndexedElement(String qName, int index) {
        Element element = this.doc.createElementNS("urn:schemas-microsoft-com:office:spreadsheet", qName);
        element.setPrefix("ss");
        element.setAttributeNodeNS(this.createAttributeNS("Index", "urn:schemas-microsoft-com:office:spreadsheet", "ss", index));
        return element;
    }

    private Attr createAttributeNS(String qName, String nameSpace, String prefix, int i) {
        Attr attr = this.doc.createAttributeNS(nameSpace, qName);
        attr.setPrefix(prefix);
        attr.setValue("" + i);
        return attr;
    }

    private Document loadDocument(String fileName) throws XelemException {
        Document document = null;
        FileInputStream is = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = new FileInputStream(fileName);
            document = builder.parse(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (FactoryConfigurationError e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (ParserConfigurationException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (SAXException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (IOException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        return document;
    }
}

