/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.x;

import nl.fountain.xelem.Area;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPane
extends AbstractXLElement
implements Pane {
    private int number;
    private int activeCol = -1;
    private int activeRow = -1;
    private String rangeSelection;

    public XPane(int paneNumber) {
        if (paneNumber < 0 || paneNumber > 3) {
            throw new IllegalArgumentException(paneNumber + ". Legal arguments are 0, 1, 2 and 3.");
        }
        this.number = paneNumber;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public void setActiveCol(int col) {
        this.activeCol = col - 1;
    }

    @Override
    public int getActiveCol() {
        return this.activeCol;
    }

    @Override
    public void setActiveRow(int row) {
        this.activeRow = row - 1;
    }

    @Override
    public int getActiveRow() {
        return this.activeRow;
    }

    @Override
    public void setActiveCell(int row, int col) {
        this.setActiveRow(row);
        this.setActiveCol(col);
    }

    @Override
    public void setRangeSelection(String rc) {
        this.rangeSelection = rc;
    }

    @Override
    public void setRangeSelection(Area area) {
        this.rangeSelection = area.getAbsoluteRange();
    }

    @Override
    public String getRangeSelection() {
        return this.rangeSelection;
    }

    @Override
    public String getTagName() {
        return "Pane";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:excel";
    }

    @Override
    public String getPrefix() {
        return "x";
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element pe = this.assemble(doc, gio);
        pe.appendChild(this.createElementNS(doc, "Number", this.number));
        if (this.activeCol > -1) {
            pe.appendChild(this.createElementNS(doc, "ActiveCol", this.activeCol));
        }
        if (this.activeRow > -1) {
            pe.appendChild(this.createElementNS(doc, "ActiveRow", this.activeRow));
        }
        if (this.rangeSelection != null) {
            pe.appendChild(this.createElementNS(doc, "RangeSelection", this.rangeSelection));
        }
        parent.appendChild(pe);
        return pe;
    }
}

