/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.UnsupportedStyleException;
import nl.fountain.xelem.XFactory;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.DuplicateNameException;
import nl.fountain.xelem.excel.ExcelWorkbook;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Workbook;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.o.ODocumentProperties;
import nl.fountain.xelem.excel.ss.SSNamedRange;
import nl.fountain.xelem.excel.ss.SSWorksheet;
import nl.fountain.xelem.excel.x.XExcelWorkbook;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XLWorkbook
extends AbstractXLElement
implements Workbook {
    private DocumentProperties documentProperties;
    private ExcelWorkbook excelWorkbook;
    private String name;
    private String filename;
    private Collection<String> docComments;
    private Map<String, Worksheet> sheets = new HashMap<String, Worksheet>();
    private List<String> sheetList = new ArrayList<String>();
    private Map<String, NamedRange> namedRanges;
    private boolean printComments = true;
    private boolean printDocComments = true;
    private boolean appendInfoSheet;
    private XFactory xFactory;
    private List<String> warnings;
    private SimpleDateFormat sdf;

    public XLWorkbook() {
        this("");
    }

    public XLWorkbook(String name) {
        this.name = name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFileName() {
        if (this.filename == null) {
            return this.name + ".xls";
        }
        return this.filename;
    }

    @Override
    public void mergeStyles(String newID, String id1, String id2) throws UnsupportedStyleException {
        this.getFactory().mergeStyles(newID, id1, id2);
    }

    @Override
    public void appendInfoSheet() {
        this.appendInfoSheet = true;
    }

    @Override
    public void setDocumentProperties(DocumentProperties docProps) {
        this.documentProperties = docProps;
    }

    @Override
    public DocumentProperties getDocumentProperties() {
        if (this.documentProperties == null) {
            this.documentProperties = new ODocumentProperties();
        }
        return this.documentProperties;
    }

    @Override
    public boolean hasDocumentProperties() {
        return this.documentProperties != null;
    }

    @Override
    public void setExcelWorkbook(ExcelWorkbook excelWb) {
        this.excelWorkbook = excelWb;
    }

    @Override
    public ExcelWorkbook getExcelWorkbook() {
        if (this.excelWorkbook == null) {
            this.excelWorkbook = new XExcelWorkbook();
        }
        return this.excelWorkbook;
    }

    @Override
    public boolean hasExcelWorkbook() {
        return this.excelWorkbook != null;
    }

    @Override
    public NamedRange addNamedRange(NamedRange nr) {
        if (this.namedRanges == null) {
            this.namedRanges = new HashMap<String, NamedRange>();
        }
        this.namedRanges.put(nr.getName(), nr);
        return nr;
    }

    @Override
    public NamedRange addNamedRange(String name, String refersTo) {
        return this.addNamedRange(new SSNamedRange(name, refersTo));
    }

    @Override
    public Map<String, NamedRange> getNamedRanges() {
        if (this.namedRanges == null) {
            return Collections.emptyMap();
        }
        return this.namedRanges;
    }

    @Override
    public Worksheet addSheet() {
        String name;
        int nr = this.sheets.size();
        while (this.sheetList.contains(name = "Sheet" + ++nr)) {
        }
        return this.addSheet(name);
    }

    @Override
    public Worksheet addSheet(String name) {
        if (name == null || "".equals(name)) {
            return this.addSheet();
        }
        return this.addSheet(new SSWorksheet(name));
    }

    @Override
    public Worksheet addSheet(Worksheet sheet) {
        if (this.sheetList.contains(sheet.getName())) {
            throw new DuplicateNameException("Duplicate name in worksheets collection: '" + sheet.getName() + "'.");
        }
        this.sheetList.add(sheet.getName());
        this.sheets.put(sheet.getName(), sheet);
        return sheet;
    }

    @Override
    public List<Worksheet> getWorksheets() {
        ArrayList<Worksheet> worksheets = new ArrayList<Worksheet>();
        for (String s : this.sheetList) {
            worksheets.add(this.sheets.get(s));
        }
        return worksheets;
    }

    @Override
    public List<String> getSheetNames() {
        return this.sheetList;
    }

    @Override
    public Worksheet getWorksheet(String name) {
        return this.sheets.get(name);
    }

    @Override
    public Worksheet getWorksheetAt(int index) {
        Worksheet ws = null;
        try {
            ws = this.sheets.get(this.sheetList.get(index));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ws;
    }

    @Override
    public Worksheet removeSheet(String name) {
        int index = this.sheetList.indexOf(name);
        if (index < 0) {
            return null;
        }
        this.sheetList.remove(index);
        return this.sheets.remove(name);
    }

    @Override
    public void setPrintElementComments(boolean print) {
        this.printComments = print;
    }

    @Override
    public void setPrintDocComments(boolean print) {
        this.printDocComments = print;
    }

    @Override
    public boolean isPrintingElementComments() {
        return this.printComments;
    }

    @Override
    public boolean isPrintingDocComments() {
        return this.printDocComments;
    }

    @Override
    public String getTagName() {
        return "Workbook";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public Document createDocument() throws ParserConfigurationException {
        GIO gio = new GIO();
        Document doc = this.getDoc();
        Element root = doc.getDocumentElement();
        this.assemble(root, gio);
        return doc;
    }

    @Override
    public Element assemble(Element root, GIO gio) {
        int selectedSheets;
        Document doc = root.getOwnerDocument();
        this.warnings = null;
        gio.setPrintComments(this.isPrintingElementComments());
        doc.insertBefore(doc.createProcessingInstruction("mso-application", "progid=\"Excel.Sheet\""), root);
        if (this.isPrintingDocComments()) {
            for (String s : this.getFactory().getDocComments()) {
                doc.insertBefore(doc.createComment(s), root);
            }
        }
        root.setAttribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        root.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        root.setAttribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        root.setAttribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        root.setAttribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
        if (this.isPrintingElementComments() && this.getElementComments() != null) {
            for (String s : this.getElementComments()) {
                root.appendChild(doc.createComment(s));
            }
        }
        if (this.hasDocumentProperties()) {
            this.documentProperties.assemble(root, gio);
        }
        Element xlwbe = this.getExcelWorkbook().assemble(root, gio);
        Element styles = doc.createElement("Styles");
        root.appendChild(styles);
        this.appendDefaultStyle(doc, styles);
        if (this.namedRanges != null) {
            Element names = doc.createElement("Names");
            root.appendChild(names);
            for (NamedRange nr : this.namedRanges.values()) {
                nr.assemble(names, gio);
            }
        }
        if (this.sheets.size() < 1) {
            this.addSheet();
        }
        for (String s : this.sheetList) {
            Worksheet ws = this.sheets.get(s);
            ws.assemble(root, gio);
        }
        if (this.appendInfoSheet) {
            try {
                this.getFactory().appendInfoSheet(root, gio);
            }
            catch (XelemException e) {
                this.addWarning(e.getCause());
            }
        }
        if ((selectedSheets = gio.getSelectedSheetsCount()) > 1) {
            Element n = doc.createElementNS("urn:schemas-microsoft-com:office:excel", "SelectedSheets");
            n.setPrefix("x");
            n.appendChild(doc.createTextNode("" + selectedSheets));
            xlwbe.appendChild(n);
        }
        this.appendStyles(doc, styles, gio);
        return root;
    }

    @Override
    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }

    private Document getDoc() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        return domImpl.createDocument("urn:schemas-microsoft-com:office:spreadsheet", this.getTagName(), null);
    }

    private void appendDefaultStyle(Document doc, Element styles) {
        Element dse = this.getFactory().getStyle("Default");
        if (dse == null) {
            dse = doc.createElement("Style");
            dse.setAttributeNodeNS(this.createAttributeNS(doc, "ID", "Default"));
            dse.setAttributeNodeNS(this.createAttributeNS(doc, "Name", "Normal"));
            Element alignment = doc.createElement("Alignment");
            dse.appendChild(alignment);
            alignment.setAttributeNodeNS(this.createAttributeNS(doc, "Vertical", "Bottom"));
            dse.appendChild(doc.createElement("Borders"));
            dse.appendChild(doc.createElement("Font"));
            dse.appendChild(doc.createElement("Interior"));
            dse.appendChild(doc.createElement("NumberFormat"));
            dse.appendChild(doc.createElement("Protection"));
        } else {
            dse = (Element)doc.importNode(dse, true);
        }
        styles.appendChild(dse);
    }

    private void appendStyles(Document doc, Element styles, GIO gio) {
        for (String id : gio.getStyleIDSet()) {
            Element style = this.getFactory().getStyle(id);
            if (style == null) {
                style = doc.createElement("Style");
                style.setAttributeNodeNS(this.createAttributeNS(doc, "ID", id));
                this.addWarning(new UnsupportedStyleException("Style '" + id + "' not found."));
            } else {
                style = (Element)doc.importNode(style, true);
            }
            styles.appendChild(style);
        }
    }

    private XFactory getFactory() {
        if (this.xFactory == null) {
            try {
                this.xFactory = XFactory.newInstance();
            }
            catch (XelemException e) {
                this.addWarning(e.getCause());
                this.xFactory = XFactory.emptyFactory();
            }
        }
        return this.xFactory;
    }

    private void addWarning(Throwable e) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
            this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        }
        StringBuffer msg = new StringBuffer("\nWARNING ");
        msg.append(this.warnings.size() + 1);
        msg.append("): ");
        msg.append(e.toString());
        StackTraceElement[] st = e.getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            msg.append("\n\tat ");
            msg.append(st[i].toString());
        }
        this.warnings.add(this.sdf.format(new Date()) + msg.toString());
    }
}

