/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.util.Iterator;
import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.XLElementTest;
import nl.fountain.xelem.excel.ss.SSCell;
import nl.fountain.xelem.excel.ss.SSRow;

public class SSRowTest
extends XLElementTest {
    private Row row;

    public static void main(String[] args) {
        TestRunner.run(SSRowTest.class);
    }

    protected void setUp() throws Exception {
        this.row = new SSRow();
    }

    public void testAddCell() {
        SSRowTest.assertEquals((int)0, (int)this.row.size());
        Cell cell = this.row.addCell();
        SSRowTest.assertEquals((int)1, (int)this.row.size());
        SSRowTest.assertSame((Object)cell, (Object)this.row.getCellMap().get(new Integer(1)));
        Cell cell2 = this.row.addCell();
        SSRowTest.assertEquals((int)2, (int)this.row.size());
        SSRowTest.assertSame((Object)cell2, (Object)this.row.getCellMap().get(new Integer(2)));
        SSRowTest.assertNotSame((Object)cell, (Object)cell2);
        Iterator<Cell> iter = this.row.getCells().iterator();
        SSRowTest.assertSame((Object)cell, (Object)iter.next());
        SSRowTest.assertSame((Object)cell2, (Object)iter.next());
        try {
            iter.next();
            SSRowTest.fail((String)"Alle cellen zijn doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testAddCell_index() {
        SSRowTest.assertEquals((int)0, (int)this.row.size());
        Cell cell = this.row.addCellAt(5);
        SSRowTest.assertEquals((int)1, (int)this.row.size());
        SSRowTest.assertSame((Object)cell, (Object)this.row.getCellMap().get(new Integer(5)));
        Cell cell6 = this.row.addCell();
        SSRowTest.assertEquals((int)2, (int)this.row.size());
        SSRowTest.assertSame((Object)cell6, (Object)this.row.getCellMap().get(new Integer(6)));
        Cell cell3 = this.row.addCellAt(3);
        SSRowTest.assertEquals((int)3, (int)this.row.size());
        SSRowTest.assertSame((Object)cell3, (Object)this.row.getCellMap().get(new Integer(3)));
        Iterator<Cell> iter = this.row.getCells().iterator();
        SSRowTest.assertSame((Object)cell3, (Object)iter.next());
        SSRowTest.assertSame((Object)cell, (Object)iter.next());
        SSRowTest.assertSame((Object)cell6, (Object)iter.next());
        try {
            iter.next();
            SSRowTest.fail((String)"Alle cellen zijn doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
        Cell cell5 = this.row.addCellAt(5);
        SSRowTest.assertEquals((int)3, (int)this.row.size());
        SSRowTest.assertSame((Object)cell5, (Object)this.row.getCellMap().get(new Integer(5)));
        Cell cell7 = this.row.addCell();
        SSRowTest.assertEquals((int)4, (int)this.row.size());
        SSRowTest.assertSame((Object)cell7, (Object)this.row.getCellMap().get(new Integer(7)));
        iter = this.row.getCells().iterator();
        SSRowTest.assertSame((Object)cell3, (Object)iter.next());
        SSRowTest.assertSame((Object)cell5, (Object)iter.next());
        SSRowTest.assertSame((Object)cell6, (Object)iter.next());
        SSRowTest.assertSame((Object)cell7, (Object)iter.next());
        try {
            iter.next();
            SSRowTest.fail((String)"Alle cellen zijn doorlopen");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testAddCell_Cell() {
        SSRowTest.assertEquals((int)0, (int)this.row.size());
        SSCell cell = new SSCell();
        Cell returnCell = this.row.addCell(cell);
        SSRowTest.assertEquals((int)1, (int)this.row.size());
        SSRowTest.assertSame((Object)cell, (Object)returnCell);
        SSRowTest.assertSame((Object)cell, (Object)this.row.getCellMap().get(new Integer(1)));
    }

    public void testAddCell_index_Cell() {
        SSRowTest.assertEquals((int)0, (int)this.row.size());
        SSCell cell = new SSCell();
        Cell returnCell = null;
        try {
            returnCell = this.row.addCellAt(-1, cell);
            SSRowTest.fail((String)"geenexceptie gegooid.");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        SSRowTest.assertEquals((int)0, (int)this.row.size());
        SSRowTest.assertNull((Object)returnCell);
        Cell returnCell2 = this.row.addCellAt(5, cell);
        SSRowTest.assertEquals((int)1, (int)this.row.size());
        SSRowTest.assertSame((Object)cell, (Object)returnCell2);
        SSRowTest.assertSame((Object)cell, (Object)this.row.getCellMap().get(new Integer(5)));
    }

    public void testRemoveCell() {
        this.row.addCell();
        Cell cell = this.row.addCell();
        this.row.addCell();
        SSRowTest.assertEquals((int)3, (int)this.row.size());
        SSRowTest.assertSame((Object)cell, (Object)this.row.removeCellAt(2));
        SSRowTest.assertEquals((int)2, (int)this.row.size());
        this.row.addCell();
        Iterator<Integer> iter = this.row.getCellMap().keySet().iterator();
        SSRowTest.assertEquals((Object)new Integer(1), (Object)iter.next());
        SSRowTest.assertEquals((Object)new Integer(3), (Object)iter.next());
        SSRowTest.assertEquals((Object)new Integer(4), (Object)iter.next());
        try {
            iter.next();
            SSRowTest.fail((String)"Alle cellen zijn doorlopen");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAssemble() {
        this.row.setStyleID("foo");
        this.row.addCell().setStyleID("bar");
        this.row.addCellAt(5);
        GIO gio = new GIO();
        String xml = this.xmlToString(this.row, gio);
        SSRowTest.assertTrue((xml.indexOf("<ss:Row ss:StyleID=\"foo\">") > 0 ? 1 : 0) != 0);
        SSRowTest.assertTrue((xml.indexOf("<ss:Cell ss:StyleID=\"bar\"/>") > 0 ? 1 : 0) != 0);
        SSRowTest.assertTrue((xml.indexOf("<ss:Cell ss:Index=\"5\"/>") > 0 ? 1 : 0) != 0);
        SSRowTest.assertEquals((int)2, (int)gio.getStyleIDSet().size());
    }
}

