/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.UnsupportedStyleException;
import nl.fountain.xelem.XelemException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XFactory {
    private static final String XMLNS_F = "urn:schemas-fountain-nl:xelem:config";
    private static final String CONFIGURATION_FILE = "config/xelem.xml";
    private static String configFileName;
    private static boolean loaded;
    private static List<String> doc_comments;
    private static Map<String, Node> styles;
    private static Set<String> issStyles;
    private static Node infoSheet;

    private XFactory() throws XelemException {
        if (!loaded) {
            this.loadConfiguration(XFactory.getConfigurationFileName());
        }
    }

    private XFactory(boolean empty) {
        if (empty) {
            // empty if block
        }
        XFactory.reset();
        this.init();
    }

    public static XFactory newInstance() throws XelemException {
        return new XFactory();
    }

    public static XFactory emptyFactory() {
        return new XFactory(true);
    }

    public static void setConfigurationFileName(String fileName) {
        XFactory.reset();
        configFileName = fileName;
    }

    public static String getConfigurationFileName() {
        if (configFileName == null) {
            return CONFIGURATION_FILE;
        }
        return configFileName;
    }

    public static void reset() {
        loaded = false;
        configFileName = null;
    }

    public List<String> getDocComments() {
        return doc_comments;
    }

    public Element getStyle(String id) {
        return (Element)styles.get(id);
    }

    public int getStylesCount() {
        return styles.size();
    }

    public Set<String> getStyleIDs() {
        return styles.keySet();
    }

    public void mergeStyles(String newID, String id1, String id2) throws UnsupportedStyleException {
        String[] elements;
        Element ne = this.getStyle(newID);
        if (ne != null) {
            return;
        }
        Element s1 = this.getStyle(id1);
        Element s2 = this.getStyle(id2);
        String notFoundId = "";
        if (s1 == null) {
            notFoundId = " '" + id1 + "'";
        }
        if (s2 == null) {
            notFoundId = notFoundId + " '" + id2 + "'";
        }
        if (s1 == null || s2 == null) {
            throw new UnsupportedStyleException("Style(s)" + notFoundId + " not found.");
        }
        ne = (Element)s1.cloneNode(true);
        ne.setAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "ID", newID);
        Attr id = s1.getOwnerDocument().createAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "ID");
        id.setPrefix("ss");
        id.setValue(newID);
        ne.setAttributeNodeNS(id);
        ne.removeAttributeNS("urn:schemas-microsoft-com:office:spreadsheet", "Name");
        Element clonedS2 = (Element)s2.cloneNode(true);
        for (String s : elements = new String[]{"Alignment", "Borders", "Font", "Interior", "NumberFormat", "Protection"}) {
            NodeList nl1;
            NodeList nl2 = clonedS2.getElementsByTagName(s);
            if (nl2.getLength() <= 0 || (nl1 = ne.getElementsByTagName(s)).getLength() != 0) continue;
            ne.appendChild(nl2.item(0));
        }
        styles.put(newID, ne);
    }

    public boolean addStyle(Element style) {
        String id = style.getAttributes().getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ID").getNodeValue();
        if (styles.containsKey(id)) {
            return false;
        }
        styles.put(id, style);
        return true;
    }

    public void appendInfoSheet(Element root, GIO gio) throws XelemException {
        if (infoSheet == null) {
            infoSheet = this.loadInfoSheet();
        }
        root.appendChild(root.getOwnerDocument().importNode(infoSheet, true));
        gio.getStyleIDSet().addAll(issStyles);
    }

    private void init() {
        doc_comments = new ArrayList<String>();
        styles = new HashMap<String, Node>();
    }

    private void loadConfiguration(String fileName) throws XelemException {
        this.init();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            File configFile = new File(fileName);
            Document config = builder.parse(configFile);
            NodeList comments = config.getElementsByTagNameNS(XMLNS_F, "comment");
            for (int i = 0; i < comments.getLength(); ++i) {
                String doc_comment = comments.item(i).getFirstChild().getNodeValue();
                doc_comments.add(doc_comment);
            }
            NodeList styleList = config.getElementsByTagName("Style");
            for (int i = 0; i < styleList.getLength(); ++i) {
                Node style = styleList.item(i);
                String id = style.getAttributes().getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ID").getNodeValue();
                styles.put(id, style);
            }
        }
        catch (DOMException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (FactoryConfigurationError e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (ParserConfigurationException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (SAXException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (IOException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        loaded = true;
    }

    Node loadInfoSheet() throws XelemException {
        issStyles = new TreeSet<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream is = this.getClass().getResourceAsStream("infoSheet.xml");
            Document infosh = builder.parse(is);
            NodeList styleList = infosh.getElementsByTagName("Style");
            for (int i = 0; i < styleList.getLength(); ++i) {
                Node style = styleList.item(i);
                String id = style.getAttributes().getNamedItemNS("urn:schemas-microsoft-com:office:spreadsheet", "ID").getNodeValue();
                if ("Default".equals(id)) continue;
                issStyles.add(id);
                styles.put(id, style);
            }
            NodeList sheets = infosh.getElementsByTagNameNS("urn:schemas-microsoft-com:office:spreadsheet", "Worksheet");
            infoSheet = sheets.item(0);
        }
        catch (ParserConfigurationException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (SAXException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        catch (IOException e) {
            throw new XelemException(e.fillInStackTrace());
        }
        return infoSheet;
    }

    static {
        loaded = false;
    }
}

