/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.replies.SlackReply;
import java.util.concurrent.TimeUnit;

class SlackMessageHandleImpl<T extends SlackReply>
implements SlackMessageHandle<T> {
    private long messageId;
    private volatile T slackReply;

    public SlackMessageHandleImpl(long messageId) {
        this.messageId = messageId;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public T getReply() {
        return this.slackReply;
    }

    void setReply(T slackReply) {
        this.slackReply = slackReply;
    }

    @Override
    public boolean isAcked() {
        return false;
    }

    @Override
    public void waitForReply(long timeout, TimeUnit unit) {
        long nanoStart = System.nanoTime();
        while (System.nanoTime() - nanoStart < unit.toNanos(timeout) && this.slackReply == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

