/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TimeMgmt {
    public static final double ONE_SECOND_IN_MILLIS = 1000.0;
    public static final double ONE_MINUTE_IN_MILLIS = 60000.0;
    public static final double ONE_HOUR_IN_MILLIS = 3600000.0;
    public static final double ONE_DAY_IN_MILLIS = 8.64E7;
    private static long lastTownyTimeCacheUpdate = System.currentTimeMillis();
    private static long cachedTownyTime = -1L;

    public static String formatCountdownTime(long l) {
        return TimeMgmt.formatCountdownTime(l, Translation.getDefaultLocale());
    }

    public static String formatCountdownTime(Long l, Locale locale) {
        String out = "";
        if (l >= 3600L) {
            int h = (int)((double)l.longValue() / 3600.0);
            out = h + Translatable.of("msg_hours").translate(locale);
            l = l - (long)h * 3600L;
        }
        if (l >= 60L) {
            int m = (int)((double)l.longValue() / 60.0);
            out = out + (out.length() > 0 ? ", " : "") + m + Translatable.of("msg_minutes").translate(locale);
            l = l - (long)m * 60L;
        }
        if (out.length() == 0 || l > 0L) {
            out = out + (out.length() > 0 ? ", " : "") + l + Translatable.of("msg_seconds").translate(locale);
        }
        return out;
    }

    public static String countdownTimeHoursRaw(long l) {
        return String.valueOf(Duration.ofSeconds(l).toHours());
    }

    public static String countdownTimeMinutesRaw(long l) {
        return String.valueOf(Duration.ofSeconds(l).toMinutes() % 60L);
    }

    public static String countdownTimeSecondsRaw(long l) {
        return String.valueOf(l % 60L);
    }

    public static String formatCountdownTimeHours(long l, Player player) {
        return Duration.ofSeconds(l).toHours() + Translatable.of("msg_hours").forLocale((CommandSender)player);
    }

    public static String formatCountdownTimeMinutes(long l, Player player) {
        return Duration.ofSeconds(l).toMinutes() % 60L + Translatable.of("msg_minutes").forLocale((CommandSender)player);
    }

    public static String formatCountdownTimeSeconds(long l, Player player) {
        return l % 60L + Translatable.of("msg_seconds").forLocale((CommandSender)player);
    }

    public static String getFormattedTimeValue(double timeMillis) {
        if (timeMillis > 0.0) {
            double timeUtilCompletion;
            String timeUnit;
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (timeMillis / 8.64E7 > 1.0) {
                numberFormat.setMaximumFractionDigits(1);
                timeUnit = Translation.of("msg_days");
                timeUtilCompletion = timeMillis / 8.64E7;
            } else if (timeMillis / 3600000.0 > 1.0) {
                numberFormat.setMaximumFractionDigits(1);
                timeUnit = Translation.of("msg_hours");
                timeUtilCompletion = timeMillis / 3600000.0;
            } else if (timeMillis / 60000.0 > 1.0) {
                numberFormat.setMaximumFractionDigits(1);
                timeUnit = Translation.of("msg_minutes");
                timeUtilCompletion = timeMillis / 60000.0;
            } else {
                numberFormat.setMaximumFractionDigits(0);
                timeUnit = Translation.of("msg_seconds");
                timeUtilCompletion = timeMillis / 1000.0;
            }
            double timeRoundedUp = Math.ceil(timeUtilCompletion * 10.0) / 10.0;
            return numberFormat.format(timeRoundedUp) + timeUnit;
        }
        return "0" + Translation.of("msg_seconds");
    }

    public static long townyTime() {
        return TimeMgmt.townyTime(false);
    }

    public static long townyTime(boolean cache) {
        if (cache && lastTownyTimeCacheUpdate + 1000L > System.currentTimeMillis() && cachedTownyTime != -1L) {
            return cachedTownyTime;
        }
        long secondsInDay = TownySettings.getDayInterval();
        Calendar now = Calendar.getInstance();
        TimeZone timeZone = now.getTimeZone();
        long timeMilli = System.currentTimeMillis();
        int timeOffset = timeZone.getOffset(timeMilli) / 1000;
        long time = Math.floorMod(secondsInDay + (TownySettings.getNewDayTime() - timeMilli / 1000L % secondsInDay - (long)timeOffset), secondsInDay);
        if (cache) {
            cachedTownyTime = time;
            lastTownyTimeCacheUpdate = System.currentTimeMillis();
        }
        return time;
    }
}

