/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.compress.archivers.tar.TarArchiveEntry;
import com.palmergames.compress.archivers.tar.TarArchiveOutputStream;
import com.palmergames.compress.compressors.gzip.GzipCompressorOutputStream;
import com.palmergames.compress.utils.IOUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class FileMgmt {
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = readWriteLock.readLock();
    private static final Lock writeLock = readWriteLock.writeLock();

    public static boolean checkOrCreateFolder(String folderPath) {
        File file = new File(folderPath);
        if (file.exists() || file.isDirectory()) {
            return true;
        }
        return FileMgmt.newDir(file);
    }

    public static boolean checkOrCreateFolders(String ... folders) {
        for (String folder : folders) {
            if (FileMgmt.checkOrCreateFolder(folder)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOrCreateFile(String filePath) {
        File file = new File(filePath);
        if (!FileMgmt.checkOrCreateFolder(file.getParentFile().getPath())) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileMgmt.newFile(file);
    }

    private static boolean newDir(File dir) {
        try {
            writeLock.lock();
            boolean bl = dir.mkdirs();
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    private static boolean newFile(File file) {
        try {
            writeLock.lock();
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean checkOrCreateFiles(String ... files) {
        for (String file : files) {
            if (FileMgmt.checkOrCreateFile(file)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        block19: {
            try {
                writeLock.lock();
                if (sourceLocation.isDirectory()) {
                    String[] children;
                    if (!targetLocation.exists()) {
                        targetLocation.mkdir();
                    }
                    for (String aChildren : children = sourceLocation.list()) {
                        FileMgmt.copyDirectory(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
                    }
                    break block19;
                }
                try (FileOutputStream out = new FileOutputStream(targetLocation);
                     FileInputStream in = new FileInputStream(sourceLocation);){
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                catch (IOException ex) {
                    Towny.getPlugin().getLogger().warning("Error: Could not access: " + sourceLocation);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean listToFile(Collection<String> source, String targetLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void moveFile(File sourceFile, String targetLocation) {
        try {
            writeLock.lock();
            if (sourceFile.isFile()) {
                File f = new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + sourceFile.getName());
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
                sourceFile.renameTo(new File(sourceFile.getParent() + File.separator + targetLocation, sourceFile.getName()));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveTownBlockFile(File sourceFile, String targetLocation, String townDir) {
        try {
            writeLock.lock();
            if (sourceFile.isFile()) {
                if (!townDir.isEmpty()) {
                    FileMgmt.checkOrCreateFolder(sourceFile.getParent() + File.separator + "deleted" + File.separator + townDir);
                } else {
                    FileMgmt.checkOrCreateFolder(sourceFile.getParent() + File.separator + "deleted");
                }
                File f = new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + townDir + File.separator + sourceFile.getName());
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
                sourceFile.renameTo(new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + townDir, sourceFile.getName()));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static String getFileTimeStamp() {
        long t = System.currentTimeMillis();
        return new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tar(File destination, File ... sources) throws IOException {
        try {
            readLock.lock();
            try (TarArchiveOutputStream archive = new TarArchiveOutputStream(new GzipCompressorOutputStream(new FileOutputStream(destination)));){
                archive.setLongFileMode(3);
                for (File sourceFile : sources) {
                    Path source = sourceFile.toPath();
                    try (Stream<Path> files = Files.walk(source, new FileVisitOption[0]);){
                        for (Path path : files.collect(Collectors.toList())) {
                            if (Files.isDirectory(path, new LinkOption[0])) continue;
                            InputStream fis = Files.newInputStream(path, new OpenOption[0]);
                            try {
                                TarArchiveEntry entry_1 = new TarArchiveEntry(path, source.getParent().relativize(path).toString(), new LinkOption[0]);
                                archive.putArchiveEntry(entry_1);
                                IOUtils.copy(fis, (OutputStream)archive);
                                archive.closeArchiveEntry();
                            }
                            finally {
                                if (fis == null) continue;
                                fis.close();
                            }
                        }
                    }
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File file, String path) {
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
            writeLock.lock();
            byte[] buffer = new byte[2056];
            zos.putNextEntry(new ZipEntry(file.getName()));
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred while zipping up file " + file.getName(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectories(File destination, File ... sourceFolders) throws IOException {
        try {
            readLock.lock();
            ZipOutputStream output = new ZipOutputStream((OutputStream)new FileOutputStream(destination), StandardCharsets.UTF_8);
            for (File sourceFolder : sourceFolders) {
                FileMgmt.recursiveZipDirectory(sourceFolder, output);
            }
            output.close();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveZipDirectory(File sourceFolder, ZipOutputStream zipStream) throws IOException {
        try {
            readLock.lock();
            String[] dirList = sourceFolder.list();
            byte[] readBuffer = new byte[2156];
            for (String aDirList : dirList) {
                File f = new File(sourceFolder, aDirList);
                if (f.isDirectory()) {
                    FileMgmt.recursiveZipDirectory(f, zipStream);
                    continue;
                }
                if (!f.isFile() || !f.canRead()) continue;
                try (FileInputStream input = new FileInputStream(f);){
                    int bytesIn;
                    ZipEntry anEntry = new ZipEntry(f.getPath());
                    zipStream.putNextEntry(anEntry);
                    while ((bytesIn = input.read(readBuffer)) != -1) {
                        zipStream.write(readBuffer, 0, bytesIn);
                    }
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(File file) {
        try {
            writeLock.lock();
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        FileMgmt.deleteFile(child);
                    }
                }
                if (!((children = file.listFiles()) != null && children.length != 0 || file.delete())) {
                    Towny.getPlugin().getLogger().warning("Error: Could not delete folder: " + file.getPath());
                }
            } else if (file.isFile() && !file.delete()) {
                Towny.getPlugin().getLogger().warning("Error: Could not delete file: " + file.getPath());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteOldBackups(File backupsDir, long deleteAfter) {
        try {
            writeLock.lock();
            TreeSet<Long> deleted = new TreeSet<Long>();
            if (!backupsDir.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            File[] children = backupsDir.listFiles();
            if (children == null) {
                boolean bl = true;
                return bl;
            }
            for (File child : children) {
                long age;
                long timeMade;
                if (child.isDirectory()) continue;
                String fileName = child.getName();
                try {
                    timeMade = TownyDatabaseHandler.BACKUP_DATE_FORMAT.parse(fileName).getTime();
                }
                catch (ParseException pe) {
                    try {
                        String[] tokens = fileName.split("\\.")[0].split(" ");
                        String lastToken = tokens[tokens.length - 1];
                        timeMade = Long.parseLong(lastToken);
                    }
                    catch (Exception e) {
                        Towny.getPlugin().getLogger().warning("File '" + fileName + "' in the backup folder does not match any format recognized by Towny, it will not be automatically deleted.");
                        continue;
                    }
                }
                if (timeMade < 0L || (age = System.currentTimeMillis() - timeMade) < deleteAfter) continue;
                FileMgmt.deleteFile(child);
                deleted.add(age);
            }
            if (deleted.size() > 0) {
                Towny.getPlugin().getLogger().info(String.format("Deleting %d Old Backups (%s).", deleted.size(), deleted.size() > 1 ? String.format("%d-%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()), TimeUnit.MILLISECONDS.toDays((Long)deleted.last())) : String.format("%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()))));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> loadFileIntoHashMap(File file) {
        try {
            readLock.lock();
            HashMap<String, String> keys = new HashMap<String, String>();
            try (FileInputStream fis = new FileInputStream(file);
                 InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(isr);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    keys.put(key, String.valueOf(value));
                }
            }
            catch (IOException e) {
                Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred while reading file " + file.getName(), e);
            }
            HashMap<String, String> hashMap = keys;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlotData(PlotBlockData data, File file, String path) {
        FileMgmt.checkOrCreateFolder(file.getPath());
        try (ZipOutputStream output = new ZipOutputStream((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
            writeLock.lock();
            output.putNextEntry(new ZipEntry(data.getX() + "_" + data.getZ() + "_" + data.getSize() + ".data"));
            try (DataOutputStream fout = new DataOutputStream(output);){
                fout.write("VER".getBytes(StandardCharsets.UTF_8));
                fout.write(data.getVersion());
                fout.writeInt(data.getHeight());
                fout.writeInt(data.getMinHeight());
                for (String block : new ArrayList<String>(data.getBlockList())) {
                    fout.writeUTF(block);
                }
            }
        }
        catch (IOException e1) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred while saving plot data to " + file.getName(), e1);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void writeString(Path path, String string) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path.toFile());){
            fos.write(string.getBytes(StandardCharsets.UTF_8));
        }
    }
}

