/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private final String version;
    private static final Pattern SEPARATOR = Pattern.compile("\\.");
    private static final Pattern VERSION_PATTERN = Pattern.compile("[0-9]+(" + SEPARATOR + "[0-9]+)*");
    private final String[] components;

    private Version(String version) {
        this.version = version;
        this.components = version.split(SEPARATOR.pattern());
    }

    public static Version fromString(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        return new Version(matcher.group(0));
    }

    @Override
    public int compareTo(@NotNull Version that) {
        int length = Math.max(this.components.length, that.components.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < this.components.length ? Integer.parseInt(this.components[i]) : 0;
            int n = thatPart = i < that.components.length ? Integer.parseInt(that.components[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version1 = (Version)o;
        return Objects.equals(this.version, version1.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return this.version;
    }

    @NotNull
    public String[] getComponents() {
        return this.components;
    }

    public boolean isPreRelease() {
        try {
            return Integer.parseInt(this.components[this.components.length - 1]) != 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isNewerThanOrEquals(@NotNull Version other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isNewerThan(@NotNull Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isOlderThanOrEquals(@NotNull Version other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isOlderThan(@NotNull Version other) {
        return this.compareTo(other) < 0;
    }
}

