/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.format.Style;
import com.palmergames.adventure.text.format.TextDecoration;
import com.palmergames.bukkit.towny.libs.pixelwidth.DefaultCharacterWidthFunction;
import com.palmergames.bukkit.towny.libs.pixelwidth.PixelWidthSource;
import org.bukkit.map.MinecraftFont;
import org.jetbrains.annotations.ApiStatus;

public class FontUtil {
    @ApiStatus.Internal
    public static final MinecraftFont font = new MinecraftFont();
    private static final PixelWidthSource widthSource = PixelWidthSource.pixelWidth(new DefaultCharacterWidthFunction(){

        @Override
        public float handleMissing(int codepoint, Style style) {
            try {
                return font.getWidth(String.valueOf((char)codepoint) + (style.hasDecoration(TextDecoration.BOLD) ? 1 : 0));
            }
            catch (IllegalArgumentException e) {
                return 6.0f;
            }
        }
    });

    public static float measureWidth(Component source) {
        return widthSource.width(source);
    }

    public static float measureWidth(String source) {
        return widthSource.width(source, Style.empty());
    }

    public static float measureWidth(String source, Style style) {
        return widthSource.width(source, style);
    }

    public static float measureWidth(char source) {
        return widthSource.width(source, Style.empty());
    }

    public static float measureWidth(char source, Style style) {
        return widthSource.width(source, style);
    }

    public static boolean isValidMinecraftFont(String text) {
        return font.isValid(text);
    }
}

