/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.FontUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ChatTools {
    private static final int DEFAULT_CHAT_WIDTH = 320;
    private static final float SPACE_WIDTH = FontUtil.measureWidth(' ');
    private static final float UNDERSCORE_WIDTH = FontUtil.measureWidth('_');
    private static final String WIDGET = ".oOo.";
    private static final float WIDGET_WIDTH = FontUtil.measureWidth(".oOo.");
    private static final String SUBWIDGET = " .]|[. ";
    private static final float SUBWIDGET_WIDTH = FontUtil.measureWidth(" .]|[. ");

    public static String listArr(String[] args, String prefix) {
        return ChatTools.list(Arrays.asList(args), prefix);
    }

    public static String list(Collection<String> args) {
        return ChatTools.list(args, "");
    }

    public static String list(Collection<String> args, String prefix) {
        if (args.isEmpty()) {
            return "";
        }
        return prefix + String.join((CharSequence)", ", args);
    }

    public static String stripColour(String s) {
        return Colors.strip(s);
    }

    public static String formatTitle(TownyObject object) {
        String title = object.getFormattedName();
        if (title.length() > 51) {
            title = object.getName();
        }
        if (title.length() > 51) {
            title = title.substring(0, 51);
        }
        return ChatTools.formatTitle(title);
    }

    public static String formatTitle(String title) {
        title = ".[ " + Translation.of("status_title_secondary_colour") + title + Translation.of("status_title_primary_colour") + " ].";
        if (!FontUtil.isValidMinecraftFont(title)) {
            return ChatTools.legacyFormatTitle(title);
        }
        float width = FontUtil.measureWidth(TownyComponents.miniMessage(title));
        float remainder = 320.0f - WIDGET_WIDTH * 2.0f - width - 2.0f;
        if (remainder < 1.0f) {
            return Translation.of("status_title_primary_colour") + title;
        }
        if (remainder < 14.0f) {
            return Translation.of("status_title_primary_colour") + WIDGET + title + WIDGET;
        }
        int times = (int)Math.floor(remainder / (UNDERSCORE_WIDTH * 2.0f));
        return Translation.of("status_title_primary_colour") + WIDGET + ChatTools.repeatChar(times, "_") + title + ChatTools.repeatChar(times, "_") + WIDGET;
    }

    private static String legacyFormatTitle(String title) {
        String line = ".oOo.__________________________________________________.oOo.";
        if (title.length() > line.length()) {
            title = title.substring(0, line.length());
        }
        int pivot = line.length() / 2;
        String center = title;
        String out = Translation.of("status_title_primary_colour") + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    public static String formatSubTitle(String subtitle) {
        if (!FontUtil.isValidMinecraftFont(subtitle)) {
            return ChatTools.legacyFormatSubtitle(subtitle);
        }
        float width = FontUtil.measureWidth(TownyComponents.miniMessage(subtitle));
        float remainder = 320.0f - SUBWIDGET_WIDTH * 2.0f - width - 2.0f;
        if (remainder < 1.0f) {
            return Translation.of("status_title_primary_colour") + subtitle;
        }
        if (remainder < 10.0f) {
            return Translation.of("status_title_primary_colour") + SUBWIDGET + subtitle + Translation.of("status_title_primary_colour") + SUBWIDGET;
        }
        int times = (int)Math.floor(remainder / (SPACE_WIDTH * 2.0f));
        return Translation.of("status_title_primary_colour") + SUBWIDGET + ChatTools.repeatChar(times, " ") + subtitle + ChatTools.repeatChar(times, " ") + Translation.of("status_title_primary_colour") + SUBWIDGET;
    }

    private static String legacyFormatSubtitle(String subtitle) {
        String line = " .]|[.                                                                     .]|[.";
        int pivot = line.length() / 2;
        String center = subtitle + Translation.of("status_title_primary_colour");
        String out = Translation.of("status_title_primary_colour") + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(Math.min(line.length(), pivot + center.length() / 2));
        return out;
    }

    private static String repeatChar(int num, String character) {
        String output = "";
        for (int i = 0; i < num; ++i) {
            output = output + character;
        }
        return output;
    }

    public static String formatCommand(String command, String subCommand, String help) {
        return ChatTools.formatCommand("", command, subCommand, help);
    }

    public static String formatCommand(String requirement, String command, String subCommand, String help) {
        String out = "  ";
        if (requirement.length() > 0) {
            out = out + Translation.of("help_menu_requirement") + requirement + ": ";
        }
        out = out + Translation.of("help_menu_command") + command;
        if (subCommand.length() > 0) {
            out = out + " " + Translation.of("help_menu_subcommand") + subCommand;
        }
        if (help.length() > 0) {
            out = out + " " + Translation.of("help_menu_explanation") + " : " + help;
        }
        return out;
    }

    public static String[] formatList(String title, String subject, List<String> list, String page) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(0, ChatTools.formatTitle(title));
        output.add(1, subject);
        output.addAll(list);
        output.add(page);
        return output.toArray(new String[0]);
    }
}

