/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.google.common.base.Charsets;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.exceptions.CancelledEventException;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitTools {
    private static Towny plugin = null;
    private static Server server = null;

    public static void initialize(Towny plugin) {
        BukkitTools.plugin = plugin;
        server = plugin.getServer();
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String name) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : Bukkit.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (PluginIntegrations.getInstance().checkCitizens((Entity)iterPlayer)) continue;
            if (name.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(name.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public static UUID getUUIDSafely(String name) {
        if (BukkitTools.hasPlayedBefore(name)) {
            return BukkitTools.getOfflinePlayer(name).getUniqueId();
        }
        return null;
    }

    @Nullable
    public static Player getPlayerExact(String name) {
        return BukkitTools.getServer().getPlayerExact(name);
    }

    @Nullable
    public static Player getPlayer(String playerId) {
        return BukkitTools.getServer().getPlayer(playerId);
    }

    @Nullable
    public static Player getPlayer(UUID playerUUID) {
        return server.getPlayer(playerUUID);
    }

    public static Collection<? extends Player> getVisibleOnlinePlayers(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return Bukkit.getOnlinePlayers();
        }
        Player player = (Player)sender;
        return Bukkit.getOnlinePlayers().stream().filter(arg_0 -> ((Player)player).canSee(arg_0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static boolean isOnline(String name) {
        return Bukkit.getPlayerExact((String)name) != null;
    }

    public static List<World> getWorlds() {
        return BukkitTools.getServer().getWorlds();
    }

    public static World getWorld(String name) {
        return BukkitTools.getServer().getWorld(name);
    }

    public static World getWorld(UUID worldUID) {
        return BukkitTools.getServer().getWorld(worldUID);
    }

    public static UUID getWorldUUID(String name) {
        World world = BukkitTools.getWorld(name);
        return world != null ? world.getUID() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getServer() {
        Server server = BukkitTools.server;
        synchronized (server) {
            return BukkitTools.server;
        }
    }

    public static PluginManager getPluginManager() {
        return BukkitTools.getServer().getPluginManager();
    }

    @Deprecated
    public static BukkitScheduler getScheduler() {
        return BukkitTools.getServer().getScheduler();
    }

    @Deprecated
    public static int scheduleSyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, task, delay);
    }

    @Deprecated
    public static int scheduleAsyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, task, delay).getTaskId();
    }

    @Deprecated
    public static int scheduleSyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, task, delay, repeat);
    }

    @Deprecated
    public static int scheduleAsyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, task, delay, repeat).getTaskId();
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            m.put(world.getName(), 0);
        }
        for (Player player : BukkitTools.getServer().getOnlinePlayers()) {
            m.put(player.getWorld().getName(), m.get(player.getWorld().getName()) + 1);
        }
        return m;
    }

    public static int calcChunk(int value) {
        return value * TownySettings.getTownBlockSize() / 16;
    }

    public static boolean hasPlayedBefore(String name) {
        return BukkitTools.getServer().getOfflinePlayer(name).hasPlayedBefore();
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        return Bukkit.getOfflinePlayer((String)name);
    }

    public static OfflinePlayer getOfflinePlayerForVault(String name) {
        return Bukkit.getOfflinePlayer((UUID)UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)));
    }

    public static String convertCoordtoXYZ(Location loc) {
        return loc.getWorld().getName() + " " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static List<String> getWorldNames() {
        return BukkitTools.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
    }

    public static List<String> getWorldNames(boolean lowercased) {
        return lowercased ? BukkitTools.getWorlds().stream().map(world -> world.getName().toLowerCase()).collect(Collectors.toList()) : BukkitTools.getWorldNames();
    }

    @Deprecated
    public static boolean checkCitizens(Entity entity) {
        return PluginIntegrations.getInstance().checkCitizens(entity);
    }

    public static Objective objective(Scoreboard board, @NotNull String name, @NotNull String displayName) {
        Objective objective;
        try {
            objective = board.registerNewObjective(name, Criteria.DUMMY, displayName);
        }
        catch (NoClassDefFoundError e) {
            objective = board.registerNewObjective(name, "dummy", displayName);
        }
        return objective;
    }

    public static boolean isEventCancelled(@NotNull Event event) {
        BukkitTools.fireEvent(event);
        if (event instanceof Cancellable) {
            Cancellable cancellable = (Cancellable)event;
            return cancellable.isCancelled();
        }
        return false;
    }

    public static void ifCancelledThenThrow(@NotNull CancellableTownyEvent event) throws CancelledEventException {
        BukkitTools.fireEvent(event);
        if (event.isCancelled()) {
            throw new CancelledEventException(event);
        }
    }

    public static void fireEvent(@NotNull Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    @Nullable
    public static String matchMaterialName(String name) {
        Material mat = (Material)BukkitTools.matchRegistry(Registry.MATERIAL, name);
        return mat == null ? null : mat.getKey().getKey().toUpperCase(Locale.ROOT);
    }

    @Nullable
    public static <T extends Keyed> T matchRegistry(Registry<T> registry, String input) {
        String filtered = input.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_").replaceAll("\\W", "");
        NamespacedKey key = NamespacedKey.fromString((String)filtered);
        return (T)(key != null ? registry.get(key) : null);
    }
}

