/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.minimessage.MiniMessage;
import com.palmergames.adventure.text.minimessage.tag.resolver.TagResolver;
import com.palmergames.adventure.text.minimessage.tag.standard.StandardTags;
import com.palmergames.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.palmergames.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.palmergames.bukkit.util.Colors;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TownyComponents {
    private static final MiniMessage EMPTY = MiniMessage.builder().tags(TagResolver.empty()).build();

    public static Component miniMessage(@NotNull String string) {
        return MiniMessage.miniMessage().deserialize(Colors.translateLegacyCharacters(Colors.translateLegacyHex(string)));
    }

    public static String plain(@NotNull Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static Component legacy(@NotNull String string) {
        return LegacyComponentSerializer.legacySection().deserialize(Colors.translateColorCodes(string));
    }

    public static String toLegacy(@NotNull Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static String stripTags(@NotNull String input) {
        return MiniMessage.miniMessage().stripTags(input);
    }

    public static String stripTags(@NotNull String input, TagResolver ... resolvers) {
        return EMPTY.stripTags(input, resolvers);
    }

    public static String stripClickTags(@NotNull String input) {
        return TownyComponents.stripTags(input, StandardTags.clickEvent());
    }

    public static Component joinList(List<Component> components, Component delimiter) {
        Component full = Component.empty();
        for (int i = 0; i < components.size(); ++i) {
            full = ((TextComponent)Component.empty().append(full)).append(components.get(i));
            if (i == components.size() - 1) continue;
            full = ((TextComponent)Component.empty().append(full)).append(delimiter);
        }
        return full;
    }
}

