/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.event.town.TownReclaimedEvent;
import com.palmergames.bukkit.towny.event.town.TownRuinedEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.ListIterator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TownRuinUtil {
    private TownRuinUtil() {
    }

    public static boolean isPlayersTownRuined(@NotNull Player player) {
        Town town = TownyAPI.getInstance().getTown(player);
        return town != null && town.isRuined();
    }

    public static void putTownIntoRuinedState(Town town) {
        if (town.isRuined()) {
            return;
        }
        Nation nation = town.getNationOrNull();
        if (nation != null) {
            double bankBalance = town.getAccount().getHoldingBalance();
            if (TownySettings.areRuinedTownsBanksPaidToNation() && bankBalance > 0.0) {
                town.getAccount().payTo(bankBalance, nation.getAccount(), String.format("Ruined Town (%s) Paid Remaining Bank To Nation", town.getName()));
            }
            town.removeNation();
        }
        String oldMayorName = town.hasMayor() ? town.getMayor().getName() : "none";
        Resident resident = ResidentUtil.createAndGetNPCResident();
        try {
            resident.setTown(town);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        resident.save();
        TownRuinUtil.setMayor(town, resident);
        town.setHasUpkeep(false);
        BukkitTools.fireEvent(new TownRuinedEvent(town, oldMayorName));
        town.setRuined(true);
        town.setRuinedTime(System.currentTimeMillis());
        town.setPublic(TownySettings.areRuinsMadePublic());
        town.setOpen(TownySettings.areRuinsMadeOpen());
        town.getPermissions().setAll(true);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.hasResident()) {
                townBlock.setResident(null);
            }
            townBlock.setType(TownBlockType.RESIDENTIAL);
            townBlock.setPlotPrice(-1.0);
            townBlock.removePlotObjectGroup();
            townBlock.getPermissionOverrides().clear();
            townBlock.getTrustedResidents().clear();
            townBlock.save();
        }
        if (town.getPlotGroups() != null) {
            for (PlotGroup group : new ArrayList<PlotGroup>(town.getPlotGroups())) {
                TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
            }
        }
        if (TownySettings.getMaxResidentsPerTown() > 0) {
            ResidentUtil.reduceResidentCountToFitTownMaxPop(town);
        }
        town.save();
        Towny.getPlugin().resetCache();
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_ruin_town", town.getName()));
    }

    public static void processRuinedTownReclaimRequest(Player player) {
        try {
            Town town;
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            Town town2 = town = resident != null ? resident.getTownOrNull() : null;
            if (town == null) {
                throw new TownyException(Translatable.of("msg_err_dont_belong_town"));
            }
            if (!town.isRuined()) {
                throw new TownyException(Translatable.of("msg_err_cannot_reclaim_town_unless_ruined"));
            }
            double townReclaimCost = TownySettings.getEcoPriceReclaimTown();
            if (TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town) > 0) {
                throw new TownyException(Translatable.of("msg_err_cannot_reclaim_town_yet", TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
            }
            if (TownyEconomyHandler.isActive() && townReclaimCost > 0.0) {
                Confirmation.runOnAccept(() -> TownRuinUtil.reclaimTown(resident, town)).setCost(new ConfirmationTransaction(() -> townReclaimCost, resident.getAccount(), "Cost of town reclaim.", Translatable.of("msg_insuf_funds"))).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(townReclaimCost))).sendTo((CommandSender)player);
            } else {
                TownRuinUtil.reclaimTown(resident, town);
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void reclaimTown(@NotNull Resident resident, @NotNull Town town) {
        town.setRuined(false);
        town.setRuinedTime(0L);
        if (!resident.equals(town.getMayor())) {
            TownRuinUtil.setMayor(town, resident);
        }
        town.getPermissions().loadDefault(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            townBlock.getPermissions().loadDefault(town);
            townBlock.setChanged(false);
            townBlock.save();
        }
        town.save();
        Towny.getPlugin().resetCache();
        BukkitTools.fireEvent(new TownReclaimedEvent(town, resident));
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_reclaimed", resident.getName(), town.getName()));
    }

    private static void setMayor(Town town, Resident newMayor) {
        Resident oldMayor = town.getMayor();
        town.setMayor(newMayor);
        if (oldMayor != null && oldMayor.isNPC()) {
            oldMayor.removeTown();
            TownyUniverse.getInstance().getDataSource().removeResident(oldMayor);
            town.setHasUpkeep(true);
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", newMayor.getName()));
    }

    public static void evaluateRuinedTownRemovals() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Town> towns = new ArrayList<Town>(townyUniverse.getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!townyUniverse.hasTown(town.getName()) || !town.isRuined() || town.getRuinedTime() == 0L || TownRuinUtil.getTimeSinceRuining(town) <= TownySettings.getTownRuinsMaxDurationHours()) continue;
            townyUniverse.getDataSource().removeTown(town, false);
        }
    }

    public static int getTimeSinceRuining(Town town) {
        return TimeTools.getHours(System.currentTimeMillis() - town.getRuinedTime());
    }
}

