/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.player.PlayerCacheGetTownBlockStatusEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class PlayerCacheUtil {
    static Towny plugin = null;

    public static void initialize(Towny plugin) {
        PlayerCacheUtil.plugin = plugin;
    }

    public static PlayerCache getCache(Player player) {
        return plugin.getCache(player);
    }

    public static boolean getCachePermission(Player player, Location location, Material material, TownyPermission.ActionType action) {
        try {
            WorldCoord worldCoord = player.getWorld().equals(location.getWorld()) ? new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location)) : new WorldCoord(location.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            boolean result = cache.getCachePermission(material, action);
            TownyMessaging.sendDebugMsg("Cache permissions for " + player.getName() + " using " + material + ":" + (Object)((Object)action) + " = " + result);
            return result;
        }
        catch (NullPointerException e) {
            WorldCoord worldCoord = location.getWorld().equals(player.getWorld()) ? new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location)) : new WorldCoord(location.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache.TownBlockStatus status = PlayerCacheUtil.cacheStatus(player, worldCoord, PlayerCacheUtil.fetchTownBlockStatus(player, worldCoord));
            PlayerCacheUtil.triggerCacheCreate(player, location, worldCoord, status, material, action);
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            boolean result = cache.getCachePermission(material, action);
            TownyMessaging.sendDebugMsg("New Cache created for " + player.getName() + " using " + material.getKey() + ":" + (Object)((Object)action) + ":" + status.name() + " = " + result);
            return result;
        }
    }

    private static void triggerCacheCreate(Player player, Location location, WorldCoord worldCoord, PlayerCache.TownBlockStatus status, Material material, TownyPermission.ActionType action) {
        boolean permission = PlayerCacheUtil.getPermission(player, status, worldCoord, material, action);
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        switch (action) {
            case BUILD: {
                cache.setBuildPermission(material, permission);
                break;
            }
            case DESTROY: {
                cache.setDestroyPermission(material, permission);
                break;
            }
            case SWITCH: {
                cache.setSwitchPermission(material, permission);
                break;
            }
            case ITEM_USE: {
                cache.setItemUsePermission(material, permission);
            }
        }
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord + ") Cached " + action.getCommonName() + ": " + permission);
    }

    public static PlayerCache.TownBlockStatus cacheStatus(Player player, WorldCoord worldCoord, PlayerCache.TownBlockStatus townBlockStatus) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setStatus(townBlockStatus);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord + ") Cached Status: " + (Object)((Object)townBlockStatus));
        return townBlockStatus;
    }

    public static void cacheBlockErrMsg(Player player, String msg) {
        PlayerCache cache = plugin.getCache(player);
        cache.setBlockErrMsg(msg);
    }

    public static PlayerCache.TownBlockStatus fetchTownBlockStatus(Player player, WorldCoord worldCoord) {
        PlayerCache.TownBlockStatus status = PlayerCacheUtil.getTownBlockStatus(player, worldCoord);
        PlayerCacheGetTownBlockStatusEvent event = new PlayerCacheGetTownBlockStatusEvent(player, worldCoord, status);
        BukkitTools.fireEvent(event);
        return event.getTownBlockStatus();
    }

    public static PlayerCache.TownBlockStatus getTownBlockStatus(Player player, WorldCoord worldCoord) {
        Town town;
        TownyWorld townyWorld = worldCoord.getTownyWorld();
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return PlayerCache.TownBlockStatus.OFF_WORLD;
        }
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        Town town2 = town = townBlock != null ? townBlock.getTownOrNull() : null;
        if (townBlock == null || town == null) {
            return TownySettings.getNationZonesEnabled() ? TownyAPI.getInstance().hasNationZone(worldCoord) : PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            if (PluginIntegrations.getInstance().checkCitizens((Entity)player)) {
                return PlayerCache.TownBlockStatus.NOT_REGISTERED;
            }
            resident = TownyUniverse.getInstance().getResident(player.getName());
            if (resident == null) {
                plugin.getLogger().warning("Failed to fetch resident: " + player.getName());
                return PlayerCache.TownBlockStatus.NOT_REGISTERED;
            }
        }
        if (town.isMayor(resident)) {
            return PlayerCache.TownBlockStatus.TOWN_OWNER;
        }
        if (town.hasTrustedResident(resident)) {
            return PlayerCache.TownBlockStatus.TOWN_TRUSTED;
        }
        if (townBlock.hasTrustedResident(resident) && !townBlock.hasResident(resident)) {
            return PlayerCache.TownBlockStatus.PLOT_TRUSTED;
        }
        Resident owner = townBlock.getResidentOrNull();
        if (owner != null) {
            if (resident == owner) {
                return PlayerCache.TownBlockStatus.PLOT_OWNER;
            }
            if (owner.hasFriend(resident)) {
                return PlayerCache.TownBlockStatus.PLOT_FRIEND;
            }
            if (resident.hasTown() && CombatUtil.isSameTown(owner, resident)) {
                return PlayerCache.TownBlockStatus.PLOT_TOWN;
            }
            if (resident.hasTown() && CombatUtil.isAlly(owner, resident)) {
                return PlayerCache.TownBlockStatus.PLOT_ALLY;
            }
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
        if (!resident.hasTown()) {
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
        if (town.hasResident(resident)) {
            return PlayerCache.TownBlockStatus.TOWN_RESIDENT;
        }
        if (CombatUtil.isSameNation(town, resident.getTownOrNull())) {
            return PlayerCache.TownBlockStatus.TOWN_NATION;
        }
        if (CombatUtil.isAlly(town, resident.getTownOrNull())) {
            return PlayerCache.TownBlockStatus.TOWN_ALLY;
        }
        if (CombatUtil.isEnemy(resident.getTownOrNull(), town)) {
            return PlayerCache.TownBlockStatus.ENEMY;
        }
        return PlayerCache.TownBlockStatus.OUTSIDER;
    }

    private static boolean getPermission(Player player, PlayerCache.TownBlockStatus status, WorldCoord pos, Material material, TownyPermission.ActionType action) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (townyUniverse.getPermissionSource().isTownyAdmin((Permissible)player)) {
            return true;
        }
        Town targetTown = pos.getTownOrNull();
        if (targetTown != null && TownySettings.isTownBankruptcyEnabled() && action == TownyPermission.ActionType.BUILD && targetTown.isBankrupt() && !targetTown.isRuined()) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_err_bankrupt_town_cannot_build").forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.OFF_WORLD || status == PlayerCache.TownBlockStatus.PLOT_OWNER || status == PlayerCache.TownBlockStatus.TOWN_OWNER) {
            return true;
        }
        Resident res = townyUniverse.getResident(player.getUniqueId());
        if (res == null) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_err_not_registered").forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.NOT_REGISTERED) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error").forLocale((CommandSender)player));
            return false;
        }
        if (TownyAPI.getInstance().isWilderness(pos)) {
            boolean hasWildOverride = townyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorld(), player, material, action);
            if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                if (hasWildOverride) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_wild", Translatable.of(action.toString())).forLocale((CommandSender)player));
                return false;
            }
            if (TownySettings.getNationZonesEnabled() && status == PlayerCache.TownBlockStatus.NATION_ZONE) {
                if (res.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_NATION_ZONE.getNode())) {
                    return true;
                }
                if (!hasWildOverride) {
                    PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_wild", Translatable.of(action.toString())).forLocale((CommandSender)player));
                    return false;
                }
                Nation nearestNation = TownyAPI.getInstance().getTownNationOrNull(pos.getTownyWorld().getClosestTownWithNationFromCoord(pos.getCoord(), null));
                if (res.hasNation() && res.getNationOrNull().getUUID().equals(nearestNation.getUUID())) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("nation_zone_this_area_under_protection_of", pos.getTownyWorld().getFormattedUnclaimedZoneName(), nearestNation.getName()).forLocale((CommandSender)player));
                return false;
            }
        }
        TownBlock townBlock = pos.getTownBlockOrNull();
        if (townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
            return true;
        }
        if (targetTown.equals(TownyAPI.getInstance().getResidentTownOrNull(res))) {
            if (townyUniverse.getPermissionSource().hasOwnTownOverride(player, material, action)) {
                return true;
            }
            if (!townBlock.hasResident() && townyUniverse.getPermissionSource().hasTownOwnedOverride(player, material, action)) {
                return true;
            }
        }
        if (townBlock.getPermissionOverrides().containsKey(res) && townBlock.getPermissionOverrides().get(res).getPermissionTypes()[action.getIndex()] != PermissionGUIUtil.SetPermissionType.UNSET) {
            PermissionGUIUtil.SetPermissionType type = townBlock.getPermissionOverrides().get(res).getPermissionTypes()[action.getIndex()];
            if (type == PermissionGUIUtil.SetPermissionType.NEGATED) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_err", Translatable.of(action.toString())).forLocale((CommandSender)player));
            }
            return type.equals((Object)PermissionGUIUtil.SetPermissionType.SET);
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_TRUSTED || status == PlayerCache.TownBlockStatus.TOWN_TRUSTED) {
            return true;
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_FRIEND) {
            if (townBlock.getPermissions().getResidentPerm(action) && PlayerCacheUtil.isAllowedMaterial(townBlock, material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_friends"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_TOWN) {
            if (townBlock.getPermissions().getNationPerm(action) && PlayerCacheUtil.isAllowedMaterial(townBlock, material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_town_members"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_RESIDENT) {
            if (townBlock.getPermissions().getResidentPerm(action) && PlayerCacheUtil.isAllowedMaterial(townBlock, material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_resident", Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_NATION) {
            if (townBlock.getPermissions().getNationPerm(action) && PlayerCacheUtil.isAllowedMaterial(townBlock, material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_nation", Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_ALLY || status == PlayerCache.TownBlockStatus.TOWN_ALLY) {
            if (townBlock.getPermissions().getAllyPerm(action) && PlayerCacheUtil.isAllowedMaterial(townBlock, material, action)) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_ALLY) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_allies"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            } else {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_allies", Translatable.of(action.toString())).forLocale((CommandSender)player));
            }
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.OUTSIDER || status == PlayerCache.TownBlockStatus.ENEMY) {
            if (townBlock.getPermissions().getOutsiderPerm(action) && PlayerCacheUtil.isAllowedMaterial(townBlock, material, action)) {
                return true;
            }
            if (townBlock.hasResident()) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_outsiders"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            } else {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_outsider", Translatable.of(action.toString())).forLocale((CommandSender)player));
            }
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.WARZONE) {
            return true;
        }
        TownyMessaging.sendErrorMsg(player, "Error updating " + action.toString() + " permission.");
        return false;
    }

    private static boolean isAllowedMaterial(TownBlock townBlock, Material material, TownyPermission.ActionType action) {
        if (!(action != TownyPermission.ActionType.BUILD && action != TownyPermission.ActionType.DESTROY || townBlock.getData().getAllowedBlocks().isEmpty())) {
            return townBlock.getData().getAllowedBlocks().contains(material);
        }
        return true;
    }
}

