/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.economy.NationPreTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.NationTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.TownPreTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.TownTransactionEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Transaction;
import com.palmergames.bukkit.towny.object.TransactionType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.util.BukkitTools;
import java.io.File;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoneyUtil {
    public static double getTownDebtCap(Town town, double upkeep) {
        return TownySettings.isDebtCapAFixedNumberOfDays() ? upkeep * (double)TownySettings.getDebtCapFixedDays() : MoneyUtil.getEstimatedValueOfTown(town);
    }

    public static double getEstimatedValueOfTown(Town town) {
        return TownySettings.getNewTownPrice() + (double)(town.getTownBlocks().size() - 1) * TownySettings.getClaimPrice() + (double)town.getAllOutpostSpawns().size() * (TownySettings.getOutpostCost() - TownySettings.getClaimPrice());
    }

    public static void townWithdraw(Player player, Resident resident, Town town, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, town, player.getLocation(), false, true);
            Transaction transaction = new Transaction(TransactionType.WITHDRAW, player, amount);
            BukkitTools.ifCancelledThenThrow(new TownPreTransactionEvent(town, transaction));
            town.withdrawFromBank(resident, amount);
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_xx_withdrew_xx", resident.getName(), amount, Translatable.of("town_sing")));
            BukkitTools.fireEvent(new TownTransactionEvent(town, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void townDeposit(Player player, Resident resident, Town town, Nation nation, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, town, player.getLocation(), false, false);
            Transaction transaction = new Transaction(TransactionType.DEPOSIT, player, amount);
            BukkitTools.ifCancelledThenThrow(new TownPreTransactionEvent(town, transaction));
            if (nation == null) {
                town.depositToBank(resident, amount);
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_xx_deposited_xx", resident.getName(), amount, Translatable.of("town_sing")));
            } else {
                resident.getAccount().payTo((double)amount, town, "Town Deposit from Nation member");
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_xx_deposited_xx", resident.getName(), amount, Translatable.literal(town.getName() + " ").append(Translatable.of("town_sing"))));
            }
            BukkitTools.fireEvent(new TownTransactionEvent(town, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void nationWithdraw(Player player, Resident resident, Nation nation, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, nation.getCapital(), player.getLocation(), true, true);
            Transaction transaction = new Transaction(TransactionType.WITHDRAW, player, amount);
            BukkitTools.ifCancelledThenThrow(new NationPreTransactionEvent(nation, transaction));
            nation.withdrawFromBank(resident, amount);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_xx_withdrew_xx", resident.getName(), amount, Translatable.of("nation_sing")));
            BukkitTools.fireEvent(new NationTransactionEvent(nation, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void nationDeposit(Player player, Resident resident, Nation nation, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, nation.getCapital(), player.getLocation(), true, false);
            Transaction transaction = new Transaction(TransactionType.DEPOSIT, player, amount);
            BukkitTools.ifCancelledThenThrow(new NationPreTransactionEvent(nation, transaction));
            nation.depositToBank(resident, amount);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_xx_deposited_xx", resident.getName(), amount, Translatable.of("nation_sing")));
            BukkitTools.fireEvent(new NationTransactionEvent(nation, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    private static void commonTests(int amount, Resident resident, Town town, Location loc, boolean nation, boolean withdraw) throws TownyException {
        Nation townNation;
        Nation nation2 = townNation = nation ? town.getNationOrNull() : null;
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_no_economy"));
        }
        if (amount < 0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        if (!withdraw && !resident.getAccount().canPayFromHoldings(amount)) {
            throw new TownyException(Translatable.of("msg_insuf_funds"));
        }
        if (!nation && town.isRuined()) {
            throw new TownyException(Translatable.of("msg_err_cannot_use_command_because_town_ruined"));
        }
        if (withdraw && (nation && !TownySettings.getNationBankAllowWithdrawls() || !nation && !TownySettings.getTownBankAllowWithdrawls())) {
            throw new TownyException(Translatable.of("msg_err_withdraw_disabled"));
        }
        if (!withdraw && (!nation && TownySettings.getTownBankCap(town) > 0.0 || nation && TownySettings.getNationBankCap(townNation) > 0.0)) {
            double bankcap = 0.0;
            double balance = 0.0;
            if (!nation && town.getBankCap() > 0.0) {
                bankcap = town.getBankCap();
                balance = town.getAccount().getHoldingBalance();
            } else if (nation && townNation.getBankCap() > 0.0) {
                bankcap = townNation.getBankCap();
                balance = townNation.getAccount().getHoldingBalance();
            }
            if (bankcap > 0.0 && (double)amount + balance > bankcap) {
                throw new TownyException(Translatable.of("msg_err_deposit_capped", bankcap));
            }
        }
        if (TownySettings.isBankActionLimitedToBankPlots() && MoneyUtil.isNotInBankPlot(town, loc)) {
            throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_bank_plot"));
        }
        if (TownySettings.isBankActionDisallowedOutsideTown() && MoneyUtil.isNotInOwnTown(town, loc)) {
            if (nation) {
                throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_nation_capital"));
            }
            throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_your_town"));
        }
        int minAmount = 0;
        if (withdraw) {
            minAmount = nation ? TownySettings.getNationMinWithdraw() : TownySettings.getTownMinWithdraw();
        } else {
            int n = minAmount = nation ? TownySettings.getNationMinDeposit() : TownySettings.getTownMinDeposit();
        }
        if (amount < minAmount) {
            throw new TownyException(Translatable.of("msg_err_must_be_greater_than_or_equal_to", TownyEconomyHandler.getFormattedBalance(minAmount)));
        }
    }

    private static boolean isNotInBankPlot(Town town, Location loc) {
        if (MoneyUtil.isNotInOwnTown(town, loc)) {
            return true;
        }
        TownBlock tb = TownyAPI.getInstance().getTownBlock(loc);
        return !tb.getType().equals(TownBlockType.BANK) && !tb.isHomeBlock();
    }

    private static boolean isNotInOwnTown(Town town, Location loc) {
        return TownyAPI.getInstance().isWilderness(loc) || !town.equals(TownyAPI.getInstance().getTown(loc));
    }

    public static void checkLegacyDebtAccounts() {
        File f = new File(TownyUniverse.getInstance().getRootFolder(), "debtAccountsConverted.txt");
        if (!f.exists()) {
            Towny.getPlugin().getScheduler().runAsyncLater(() -> TownyEconomyHandler.economyExecutor().execute(MoneyUtil::convertLegacyDebtAccounts), 600L);
        }
    }

    private static void convertLegacyDebtAccounts() {
        for (Town town : TownyUniverse.getInstance().getTowns()) {
            String name = "[DEBT]-" + town.getName();
            if (!TownyEconomyHandler.hasAccount(name)) continue;
            town.setDebtBalance(TownyEconomyHandler.getBalance(name, town.getAccount().getBukkitWorld()));
            town.save();
            TownyEconomyHandler.setBalance(name, 0.0, town.getAccount().getBukkitWorld());
        }
        Towny.getPlugin().saveResource("debtAccountsConverted.txt", false);
    }

    public static double getMoneyAboveZeroOrThrow(String input) throws TownyException {
        double amount;
        try {
            amount = Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
        if (amount < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        return amount;
    }

    public static double returnPurchasedBlocksCost(int start, int end, Town town) {
        int n = start + end > TownySettings.getMaxPurchasedBlocks(town) ? TownySettings.getMaxPurchasedBlocks(town) - start : end;
        if (n == 0) {
            return n;
        }
        Function<Integer, Long> priceFunction = num -> Math.round(Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), num.intValue()) * TownySettings.getPurchasedBonusBlocksCost());
        boolean hasMaxPrice = TownySettings.getPurchasedBonusBlocksMaxPrice() != -1.0;
        double maxPrice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        double nextPrice = priceFunction.apply(start).longValue();
        double cost = !hasMaxPrice ? nextPrice : Math.min(maxPrice, nextPrice);
        for (int i = 1; i < n; ++i) {
            nextPrice = priceFunction.apply(start + i).longValue();
            if (hasMaxPrice && nextPrice > maxPrice) {
                cost += maxPrice * (double)(end - i);
                break;
            }
            cost += nextPrice;
        }
        return Math.round(cost);
    }
}

