/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.util.EntityLists;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTypeUtil {
    private static int attempted = 0;
    private static final Map<EntityType, Material> ENTITY_TYPE_MATERIAL_MAP = JavaUtil.make(() -> {
        HashMap<EntityType, Material> map = new HashMap<EntityType, Material>();
        EntityTypeUtil.register(map, "axolotl", "axolotl_bucket");
        EntityTypeUtil.register(map, "cod", "cod");
        EntityTypeUtil.register(map, "salmon", "salmon");
        EntityTypeUtil.register(map, "pufferfish", "pufferfish");
        EntityTypeUtil.register(map, "tropical_fish", "tropical_fish");
        EntityTypeUtil.register(map, "tadpole", "tadpole_bucket");
        EntityTypeUtil.register(map, "item_frame", "item_frame");
        EntityTypeUtil.register(map, "glow_item_frame", "glow_item_frame");
        EntityTypeUtil.register(map, "painting", "painting");
        EntityTypeUtil.register(map, "armor_stand", "armor_stand");
        EntityTypeUtil.register(map, "leash_knot", "lead");
        EntityTypeUtil.register(map, "end_crystal", "end_crystal");
        EntityTypeUtil.register(map, "minecart", "minecart");
        EntityTypeUtil.register(map, "spawner_minecart", "minecart");
        EntityTypeUtil.register(map, "chest_minecart", "chest_minecart");
        EntityTypeUtil.register(map, "furnace_minecart", "furnace_minecart");
        EntityTypeUtil.register(map, "command_block_minecart", "command_block_minecart");
        EntityTypeUtil.register(map, "hopper_minecart", "hopper_minecart");
        EntityTypeUtil.register(map, "tnt_minecart", "tnt_minecart");
        EntityTypeUtil.register(map, "boat", "oak_boat");
        EntityTypeUtil.register(map, "chest_boat", "oak_chest_boat");
        TownyMessaging.sendDebugMsg("[EntityTypeUtil] Attempted: " + attempted + " | Registered: " + map.size());
        return map;
    });

    public static boolean isInstanceOfAny(List<Class<?>> classes, Object obj) {
        for (Class<?> c : classes) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProtectedEntity(Entity entity) {
        return EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), entity);
    }

    public static List<Class<?>> parseLivingEntityClassNames(List<String> mobClassNames, String errorPrefix) {
        ArrayList livingEntityClasses = new ArrayList();
        for (String mobClassName : mobClassNames) {
            if (mobClassName.isEmpty()) continue;
            try {
                Class<?> c = Class.forName("org.bukkit.entity." + mobClassName);
                livingEntityClasses.add(c);
            }
            catch (ClassNotFoundException e) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable class.", errorPrefix, mobClassName));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable living entity.", errorPrefix, mobClassName));
            }
        }
        return livingEntityClasses;
    }

    @Nullable
    public static Material parseEntityToMaterial(EntityType entityType) {
        Material lookup = ENTITY_TYPE_MATERIAL_MAP.get(entityType);
        if (lookup != null) {
            return lookup;
        }
        return (Material)Registry.MATERIAL.get(entityType.getKey());
    }

    @NotNull
    public static Material parseEntityToMaterial(EntityType entityType, @NotNull Material defaultValue) {
        Material material = EntityTypeUtil.parseEntityToMaterial(entityType);
        return material == null ? defaultValue : material;
    }

    public static boolean isExplosive(EntityType entityType) {
        return EntityLists.EXPLOSIVE.contains(entityType);
    }

    public static boolean isPVPExplosive(EntityType entityType) {
        return EntityLists.PVP_EXPLOSIVE.contains(entityType);
    }

    public static boolean isPVMExplosive(EntityType entityType) {
        return EntityLists.PVE_EXPLOSIVE.contains(entityType);
    }

    private static void register(Map<EntityType, Material> map, String name, String mat) {
        ++attempted;
        EntityType type = (EntityType)Registry.ENTITY_TYPE.get(NamespacedKey.minecraft((String)name));
        Material material = (Material)Registry.MATERIAL.get(NamespacedKey.minecraft((String)mat));
        if (type == null || material == null) {
            TownyMessaging.sendDebugMsg("[EntityTypeUtil] Could not map " + name + " to " + mat);
            return;
        }
        map.put(type, material);
    }
}

