/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.damage.TownBlockPVPTestEvent;
import com.palmergames.bukkit.towny.event.damage.TownyDispenserDamageEntityEvent;
import com.palmergames.bukkit.towny.event.damage.TownyFriendlyFireTestEvent;
import com.palmergames.bukkit.towny.event.damage.TownyPlayerDamagePlayerEvent;
import com.palmergames.bukkit.towny.event.damage.WildernessPVPTestEvent;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.EntityLists;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class CombatUtil {
    public static boolean preventDamageCall(Entity attacker, Entity defender, EntityDamageEvent.DamageCause cause) {
        Player player;
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(defender.getWorld());
        if (world == null || !world.isUsingTowny()) {
            return false;
        }
        Player a = null;
        Player b = null;
        Entity directSource = attacker;
        if (attacker instanceof Projectile) {
            BlockProjectileSource blockProjectileSource;
            Projectile projectile = (Projectile)attacker;
            ProjectileSource source = projectile.getShooter();
            if (source instanceof Entity) {
                Entity entity;
                directSource = entity = (Entity)source;
            } else if (source instanceof BlockProjectileSource && CombatUtil.preventDispenserDamage((blockProjectileSource = (BlockProjectileSource)source).getBlock(), defender, cause)) {
                return true;
            }
        }
        if (directSource instanceof Player) {
            a = player = (Player)directSource;
        }
        if (defender instanceof Player) {
            b = player = (Player)defender;
        }
        if (a == b && a != null && b != null) {
            return false;
        }
        return CombatUtil.preventDamageCall(world, attacker, defender, a, b, cause);
    }

    private static boolean preventDamageCall(TownyWorld world, Entity attackingEntity, Entity defendingEntity, Player attackingPlayer, Player defendingPlayer, EntityDamageEvent.DamageCause cause) {
        Wolf wolf;
        Projectile projectileAttacker = null;
        if (attackingEntity instanceof Projectile) {
            Projectile projectile;
            projectileAttacker = projectile = (Projectile)attackingEntity;
            ProjectileSource projectileSource = projectile.getShooter();
            if (projectileSource instanceof Entity) {
                Entity entity;
                attackingEntity = entity = (Entity)projectileSource;
            }
        }
        TownBlock defenderTB = TownyAPI.getInstance().getTownBlock(defendingEntity.getLocation());
        TownBlock attackerTB = TownyAPI.getInstance().getTownBlock(attackingEntity.getLocation());
        if (attackingPlayer != null) {
            Material material;
            boolean cancelled = false;
            if (defendingPlayer != null) {
                TownyPlayerDamagePlayerEvent event;
                if (!CombatUtil.isArenaPlot(attackerTB, defenderTB)) {
                    boolean bl = cancelled = CombatUtil.preventFriendlyFire(attackingPlayer, defendingPlayer, world) || CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB) || CombatUtil.preventJailedPVP(defendingPlayer, attackingPlayer);
                }
                if (BukkitTools.isEventCancelled(event = new TownyPlayerDamagePlayerEvent(defendingPlayer.getLocation(), (Entity)defendingPlayer, cause, defenderTB, cancelled, attackingPlayer)) && event.getMessage() != null) {
                    TownyMessaging.sendErrorMsg(attackingPlayer, event.getMessage());
                }
                return event.isCancelled();
            }
            if (defenderTB != null) {
                if (defendingEntity instanceof Wolf) {
                    Wolf wolf2 = (Wolf)defendingEntity;
                    if (!CombatUtil.isOwner(wolf2, attackingPlayer) && !CombatUtil.isTargetingPlayer(wolf2, attackingPlayer)) {
                        if (EntityTypeUtil.isProtectedEntity(defendingEntity)) {
                            return !defenderTB.getPermissions().pvp && !TownyActionEventExecutor.canDestroy(attackingPlayer, wolf2.getLocation(), Material.STONE);
                        }
                    } else {
                        return false;
                    }
                }
                if (defenderTB.getType() == TownBlockType.FARM && TownySettings.getFarmAnimals().contains(defendingEntity.getType().toString())) {
                    return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), Material.WHEAT);
                }
                if (EntityTypeUtil.isProtectedEntity(defendingEntity)) {
                    return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), Material.DIRT);
                }
            }
            if (EntityLists.DESTROY_PROTECTED.contains(defendingEntity) && (material = EntityTypeUtil.parseEntityToMaterial(defendingEntity.getType())) != null) {
                return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), material);
            }
        } else if (defendingPlayer != null) {
            if (attackingEntity instanceof Wolf) {
                wolf = (Wolf)attackingEntity;
                if (CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB)) {
                    wolf.setTarget(null);
                    wolf.setAngry(false);
                    return true;
                }
            }
            if (attackingEntity instanceof LightningStrike && world.hasTridentStrike(attackingEntity.getUniqueId()) && CombatUtil.preventPvP(world, defenderTB)) {
                return true;
            }
        } else {
            if (defenderTB == null) {
                return false;
            }
            if (!TownySettings.areProtectedEntitiesProtectedAgainstMobs()) {
                return false;
            }
            if (projectileAttacker != null && EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                return true;
            }
            if (attackingEntity instanceof Wolf) {
                wolf = (Wolf)attackingEntity;
                if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                    if (CombatUtil.isATamedWolfWithAOnlinePlayer(wolf)) {
                        Player owner = BukkitTools.getPlayerExact(wolf.getOwner().getName());
                        return !PlayerCacheUtil.getCachePermission(owner, defendingEntity.getLocation(), Material.AIR, TownyPermission.ActionType.DESTROY);
                    }
                    wolf.setTarget(null);
                    wolf.setAngry(false);
                    return true;
                }
            }
            if (attackingEntity.getType().getKey().equals((Object)NamespacedKey.minecraft((String)"axolotl")) && EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                return true;
            }
        }
        return false;
    }

    private static boolean preventJailedPVP(Player defendingPlayer, Player attackingPlayer) {
        if (TownySettings.doJailPlotsPreventPVP()) {
            Resident defendingResident = TownyAPI.getInstance().getResident(defendingPlayer.getUniqueId());
            Resident attackingResident = TownyAPI.getInstance().getResident(attackingPlayer.getUniqueId());
            TownBlock defTB = TownyAPI.getInstance().getTownBlock(defendingPlayer);
            TownBlock atkTB = TownyAPI.getInstance().getTownBlock(attackingPlayer);
            if (defendingResident == null || attackingResident == null) {
                return false;
            }
            if (defendingResident.isJailed() && defTB != null && defTB.isJail() || attackingResident.isJailed() && atkTB != null && atkTB.isJail()) {
                return true;
            }
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld world, TownBlock townBlock) {
        if (townBlock != null) {
            TownBlockPVPTestEvent event = new TownBlockPVPTestEvent(townBlock, CombatUtil.isPvP(townBlock));
            BukkitTools.fireEvent(event);
            return !event.isPvp();
        }
        WildernessPVPTestEvent event = new WildernessPVPTestEvent(world, CombatUtil.isWorldPvP(world));
        BukkitTools.fireEvent(event);
        return !event.isPvp();
    }

    private static boolean isPvP(@NotNull TownBlock townBlock) {
        if (townBlock.getTownOrNull().isAdminDisabledPVP()) {
            return false;
        }
        if (!(townBlock.getPermissions().pvp || townBlock.getTownOrNull().isPVP() || townBlock.getWorld().isForcePVP())) {
            return false;
        }
        return !townBlock.isHomeBlock() || !townBlock.getWorld().isForcePVP() || !TownySettings.isForcePvpNotAffectingHomeblocks();
    }

    public static boolean isWorldPvP(TownyWorld world) {
        return world.isForcePVP() || world.isPVP();
    }

    public static boolean preventFriendlyFire(Player attacker, Player defender, TownyWorld world) {
        if (attacker == defender) {
            return false;
        }
        if (attacker != null && defender != null && !world.isFriendlyFireEnabled() && CombatUtil.isAlly(attacker.getName(), defender.getName())) {
            if (CombatUtil.isArenaPlot(attacker, defender)) {
                return false;
            }
            TownyFriendlyFireTestEvent event = new TownyFriendlyFireTestEvent(attacker, defender, world);
            BukkitTools.fireEvent(event);
            if (!event.isPVP() && !event.getCancelledMessage().isEmpty()) {
                TownyMessaging.sendErrorMsg(attacker, event.getCancelledMessage());
            }
            return !event.isPVP();
        }
        return false;
    }

    public static boolean isArenaPlot(Player attacker, Player defender) {
        TownBlock attackerTB = TownyAPI.getInstance().getTownBlock(attacker);
        TownBlock defenderTB = TownyAPI.getInstance().getTownBlock(defender);
        return CombatUtil.isArenaPlot(attackerTB, defenderTB);
    }

    public static boolean isArenaPlot(TownBlock attackerTB, TownBlock defenderTB) {
        return defenderTB != null && attackerTB != null && defenderTB.getType() == TownBlockType.ARENA && attackerTB.getType() == TownBlockType.ARENA;
    }

    public static boolean isAlly(String attackingResident, String defendingResident) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident residentA = townyUniverse.getResident(attackingResident);
        Resident residentB = townyUniverse.getResident(defendingResident);
        if (residentA == null || residentB == null || !residentA.hasTown() || !residentB.hasTown()) {
            return false;
        }
        return CombatUtil.isAlly(residentA.getTownOrNull(), residentB.getTownOrNull());
    }

    public static boolean isAlly(Resident a, Resident b) {
        if (a == null || b == null || !a.hasTown() || !b.hasTown()) {
            return false;
        }
        return CombatUtil.isAlly(a.getTownOrNull(), b.getTownOrNull());
    }

    public static boolean isAlly(Town a, Town b) {
        if (CombatUtil.isSameTown(a, b)) {
            return true;
        }
        if (a.hasAlly(b)) {
            return true;
        }
        if (CombatUtil.isSameNation(a, b)) {
            return true;
        }
        return a.hasNation() && b.hasNation() && a.getNationOrNull().hasAlly(b.getNationOrNull());
    }

    public static boolean isSameNation(Town a, Town b) {
        if (CombatUtil.isSameTown(a, b)) {
            return true;
        }
        return a.hasNation() && b.hasNation() && a.getNationOrNull().equals(b.getNationOrNull());
    }

    public static boolean isSameTown(Town a, Town b) {
        return a == b;
    }

    public static boolean isSameNation(Resident a, Resident b) {
        if (!a.hasTown() || !b.hasTown()) {
            return false;
        }
        return CombatUtil.isSameNation(a.getTownOrNull(), b.getTownOrNull());
    }

    public static boolean isSameTown(Resident a, Resident b) {
        if (!a.hasTown() || !b.hasTown()) {
            return false;
        }
        return CombatUtil.isSameTown(a.getTownOrNull(), b.getTownOrNull());
    }

    public static boolean areAllAllies(List<Nation> possibleAllies) {
        if (possibleAllies.size() <= 1) {
            return true;
        }
        for (int i = 0; i < possibleAllies.size() - 1; ++i) {
            if (possibleAllies.get(i).hasAlly(possibleAllies.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllFriends(List<Resident> possibleFriends) {
        if (possibleFriends.size() <= 1) {
            return true;
        }
        for (int i = 0; i < possibleFriends.size() - 1; ++i) {
            if (possibleFriends.get(i).hasFriend(possibleFriends.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnemy(String a, String b) {
        Resident residentA = TownyUniverse.getInstance().getResident(a);
        Resident residentB = TownyUniverse.getInstance().getResident(b);
        if (residentA == null || residentB == null || !residentA.hasTown() || !residentB.hasTown()) {
            return false;
        }
        return CombatUtil.isEnemy(residentA.getTownOrNull(), residentB.getTownOrNull());
    }

    public static boolean isEnemy(Resident a, Resident b) {
        if (a == null || b == null || !a.hasTown() || !b.hasTown()) {
            return false;
        }
        return CombatUtil.isEnemy(a.getTownOrNull(), b.getTownOrNull());
    }

    public static boolean isEnemy(Town a, Town b) {
        if (a.hasEnemy(b)) {
            return true;
        }
        if (!a.hasNation() || !b.hasNation()) {
            return false;
        }
        if (CombatUtil.isSameTown(a, b) || CombatUtil.isSameNation(a, b)) {
            return false;
        }
        return a.getNationOrNull().hasEnemy(b.getNationOrNull());
    }

    public static boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident != null && resident.hasTown() && worldCoord.hasTownBlock()) {
            return CombatUtil.isEnemy(worldCoord.getTownOrNull(), resident.getTownOrNull());
        }
        return false;
    }

    private static boolean isOwner(Wolf wolf, Player attackingPlayer) {
        HumanEntity owner;
        AnimalTamer animalTamer = wolf.getOwner();
        return animalTamer instanceof HumanEntity && (owner = (HumanEntity)animalTamer).getUniqueId().equals(attackingPlayer.getUniqueId());
    }

    private static boolean isTargetingPlayer(Wolf wolf, Player attackingPlayer) {
        return wolf.isAngry() && wolf.getTarget() != null && wolf.getTarget().equals(attackingPlayer);
    }

    private static boolean isATamedWolfWithAOnlinePlayer(Wolf wolf) {
        HumanEntity owner;
        AnimalTamer animalTamer = wolf.getOwner();
        return animalTamer instanceof HumanEntity && Bukkit.getPlayer((UUID)(owner = (HumanEntity)animalTamer).getUniqueId()) != null;
    }

    public static boolean preventDispenserDamage(Block dispenser, Entity entity, EntityDamageEvent.DamageCause cause) {
        TownBlock dispenserTB = WorldCoord.parseWorldCoord(dispenser).getTownBlockOrNull();
        TownBlock defenderTB = WorldCoord.parseWorldCoord(entity).getTownBlockOrNull();
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(dispenser.getWorld());
        if (world == null || !world.isUsingTowny()) {
            return false;
        }
        boolean preventDamage = false;
        if (!CombatUtil.isArenaPlot(dispenserTB, defenderTB)) {
            preventDamage = CombatUtil.preventPvP(world, dispenserTB) || CombatUtil.preventPvP(world, defenderTB);
        }
        return BukkitTools.isEventCancelled(new TownyDispenserDamageEntityEvent(entity.getLocation(), entity, cause, defenderTB, preventDamage, dispenser));
    }
}

