/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.paperlib.PaperLib;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ProtectionRegenTask
extends TownyTimerTask {
    private final BlockState state;
    private BlockLocation blockLocation;
    private ScheduledTask task;
    private ItemStack[] contents;

    public ProtectionRegenTask(Towny plugin, Block block) {
        super(plugin);
        this.state = block.getState();
        this.setBlockLocation(new BlockLocation(block.getLocation()));
        if (this.state instanceof BlockInventoryHolder) {
            BlockInventoryHolder container = (BlockInventoryHolder)this.state;
            Inventory inventory = container.getInventory();
            if (this.state instanceof Chest) {
                inventory = ((Chest)this.state).getBlockInventory();
            }
            this.contents = (ItemStack[])inventory.getContents().clone();
            inventory.clear();
        }
    }

    @Override
    public void run() {
        if (PaperLib.isPaper()) {
            PaperLib.getChunkAtAsync(this.state.getLocation()).thenRun(() -> this.plugin.getScheduler().run(this.state.getLocation(), this::replaceProtections));
        } else {
            this.replaceProtections();
        }
        TownyRegenAPI.removeProtectionRegenTask(this);
    }

    public void replaceProtections() {
        Block block = this.state.getBlock();
        BlockData blockData = this.state.getBlockData().clone();
        block.setType(this.state.getType(), false);
        block.setBlockData(blockData);
        if (this.state instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)this.state;
            EntityType type = spawner.getSpawnedType();
            ((CreatureSpawner)this.state).setSpawnedType(type);
            this.state.update();
        }
        if (this.state instanceof BlockInventoryHolder) {
            BlockInventoryHolder container = (BlockInventoryHolder)this.state;
            if (container instanceof Chest) {
                ((Chest)this.state).getBlockInventory().setContents(this.contents);
            } else {
                ((BlockInventoryHolder)this.state).getInventory().setContents(this.contents);
            }
            this.state.update();
        }
        if (this.state instanceof Banner) {
            Banner banner = (Banner)this.state;
            ((Banner)this.state).setPatterns(banner.getPatterns());
            this.state.update();
        }
    }

    public BlockLocation getBlockLocation() {
        return this.blockLocation;
    }

    private void setBlockLocation(BlockLocation blockLocation) {
        this.blockLocation = blockLocation;
    }

    public BlockState getState() {
        return this.state;
    }

    @Deprecated
    public int getTaskId() {
        return -1;
    }

    @Deprecated
    public void setTaskId(int taskId) {
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public void setTask(ScheduledTask task) {
        this.task = task;
    }
}

