/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.adventure.audience.Audience;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.event.resident.NewResidentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

public class OnPlayerLogin
implements Runnable {
    private final Towny plugin;
    private final TownyUniverse universe = TownyUniverse.getInstance();
    private final Player player;

    public OnPlayerLogin(Towny plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public void run() {
        Resident resident = this.universe.getResident(this.player.getUniqueId());
        if (resident == null) {
            resident = this.universe.getResident(this.player.getName());
            if (resident != null && !resident.hasUUID()) {
                this.loginExistingResident(resident);
            } else if (resident != null && !resident.getUUID().equals(this.player.getUniqueId())) {
                try {
                    this.universe.unregisterResident(resident);
                    resident.setUUID(this.player.getUniqueId());
                    this.universe.registerResident(resident);
                }
                catch (AlreadyRegisteredException | NotRegisteredException townyException) {
                    // empty catch block
                }
                this.loginExistingResident(resident);
            } else {
                try {
                    Town town;
                    resident = this.universe.getDataSource().newResident(this.player.getName(), this.player.getUniqueId());
                    TownySettings.incrementUUIDCount();
                    if (TownySettings.isShowingLocaleMessage()) {
                        TownyMessaging.sendMsg(resident, Translatable.of("msg_your_locale", this.player.getLocale()));
                    }
                    resident.setRegistered(System.currentTimeMillis());
                    Resident finalResident = resident;
                    this.universe.getDataSource().getHibernatedResidentRegistered(this.player.getUniqueId()).thenAccept(registered -> {
                        if (registered.isPresent()) {
                            finalResident.setRegistered((Long)registered.get());
                            finalResident.save();
                        }
                    });
                    resident.setLastOnline(System.currentTimeMillis());
                    if (!TownySettings.getDefaultTownName().equals("") && (town = TownyUniverse.getInstance().getTown(TownySettings.getDefaultTownName())) != null) {
                        try {
                            resident.setTown(town);
                            town.save();
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {
                            // empty catch block
                        }
                    }
                    resident.save();
                    BukkitTools.fireEvent(new NewResidentEvent(resident));
                }
                catch (NotRegisteredException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not register resident '" + this.player.getName() + "' (" + this.player.getUniqueId() + ") due to an error, Towny features might be limited for this player until it is resolved", e);
                }
                catch (AlreadyRegisteredException e) {}
            }
        } else {
            if (!resident.getName().equals(this.player.getName())) {
                try {
                    this.universe.getDataSource().renamePlayer(resident, this.player.getName());
                }
                catch (AlreadyRegisteredException | NotRegisteredException e) {
                    this.plugin.getLogger().log(Level.WARNING, "An exception occurred when trying to rename " + resident.getName() + " to " + this.player.getName(), e);
                }
            }
            resident = this.universe.getResident(this.player.getUniqueId());
            this.loginExistingResident(resident);
        }
        if (resident != null) {
            Town insideTown;
            TownyPerms.assignPermissions(resident, this.player);
            Town town = resident.getTownOrNull();
            if (town != null) {
                Nation nation = resident.getNationOrNull();
                if (TownySettings.getShowTownBoardOnLogin() && !town.getBoard().isEmpty()) {
                    TownyMessaging.sendTownBoard((CommandSender)this.player, town);
                }
                if (TownySettings.getShowNationBoardOnLogin() && nation != null && !nation.getBoard().isEmpty()) {
                    TownyMessaging.sendNationBoard((CommandSender)this.player, nation);
                }
                if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
                    Resident finalResident = resident;
                    TownyEconomyHandler.economyExecutor().execute(() -> this.warningMessage(finalResident, town, nation));
                }
                if (TownySettings.isOverClaimingAllowingStolenLand() && town.getTownBlocks().size() > town.getMaxTownBlocks()) {
                    TownyMessaging.sendMsg(resident, Translatable.literal("\u00a74").append(Translatable.of("msg_warning_your_town_is_overclaimed")));
                }
                if (town.isRuined()) {
                    TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_your_town_is_ruined_for_x_more_hours", TownySettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
                }
            }
            if ((insideTown = TownyAPI.getInstance().getTown(this.player.getLocation())) != null && insideTown.hasOutlaw(resident)) {
                ResidentUtil.outlawEnteredTown(resident, town, this.player.getLocation());
            }
            this.plugin.getScheduler().runLater((Entity)this.player, (Runnable)new SetDefaultModes(this.player.getName(), false), 1L);
            if (TownyUpdateChecker.shouldShowNotification() && this.player.hasPermission(PermissionNodes.TOWNY_ADMIN_UPDATEALERTS.getNode())) {
                Audience audience = Towny.getAdventure().player(this.player);
                ClickEvent clickEvent = ClickEvent.openUrl(TownyUpdateChecker.getUpdateURL());
                audience.sendMessage(Translatable.of("default_towny_prefix").append(Translatable.of("msg_new_update_available", TownyUpdateChecker.getNewVersion(), Towny.getPlugin().getVersion())).locale((CommandSender)this.player).component().clickEvent(clickEvent));
                audience.sendMessage(Translatable.of("default_towny_prefix").append(Translatable.of("msg_click_to_download")).locale((CommandSender)this.player).component().clickEvent(clickEvent));
            }
        }
    }

    private void loginExistingResident(Resident resident) {
        this.plugin.getScheduler().runLater((Entity)this.player, () -> {
            if (this.player.getMetadata("vanished").stream().noneMatch(MetadataValue::asBoolean)) {
                resident.setLastOnline(System.currentTimeMillis());
            }
            if (!resident.hasUUID()) {
                resident.setUUID(this.player.getUniqueId());
                try {
                    TownyUniverse.getInstance().registerResidentUUID(resident);
                }
                catch (AlreadyRegisteredException e) {
                    this.plugin.getLogger().log(Level.WARNING, "uuid for resident " + resident.getName() + " was already registered! (" + this.player.getUniqueId() + ")", e);
                }
                TownySettings.incrementUUIDCount();
            }
            resident.save();
        }, 5L);
    }

    private void warningMessage(Resident resident, Town town, Nation nation) {
        double upkeep;
        if (town.hasUpkeep() && (upkeep = TownySettings.getTownUpkeepCost(town)) > 0.0 && !town.getAccount().canPayFromHoldings(upkeep)) {
            if (TownySettings.isTownBankruptcyEnabled()) {
                Translatable msg = !town.isBankrupt() ? Translatable.of("msg_warning_bankrupt", town.getName()) : Translatable.of("msg_your_town_is_bankrupt");
                TownyMessaging.sendMsg(resident, msg);
            } else {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_delete", town.getName()));
            }
        }
        if (nation != null && (upkeep = TownySettings.getNationUpkeepCost(nation)) > 0.0 && !nation.getAccount().canPayFromHoldings(upkeep)) {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_delete", nation.getName()));
        }
    }
}

