/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.MobRemovalEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.jetbrains.annotations.NotNull;

public class MobRemovalTimerTask
extends TownyTimerTask {
    public static List<Class<?>> classesOfWorldMobsToRemove = new ArrayList();
    public static List<Class<?>> classesOfWildernessMobsToRemove = new ArrayList();
    public static List<Class<?>> classesOfTownMobsToRemove = new ArrayList();
    private boolean isRemovingKillerBunny;

    public MobRemovalTimerTask(Towny plugin) {
        super(plugin);
        this.populateFields();
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:mob-removal-task"), config -> this.populateFields());
    }

    public static boolean isRemovingWorldEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfWorldMobsToRemove, livingEntity);
    }

    public static boolean isRemovingWildernessEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfWildernessMobsToRemove, livingEntity);
    }

    public static boolean isRemovingTownEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfTownMobsToRemove, livingEntity);
    }

    @Override
    public void run() {
        for (World world : Bukkit.getWorlds()) {
            List entities;
            TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(world);
            if (townyWorld == null || !townyWorld.isUsingTowny() || townyWorld.isForceTownMobs() && townyWorld.hasWorldMobs() || (entities = world.getLivingEntities()).isEmpty()) continue;
            for (LivingEntity entity : entities) {
                if (entity instanceof Player || PluginIntegrations.getInstance().checkCitizens((Entity)entity)) continue;
                if (!townyWorld.hasWorldMobs() && MobRemovalTimerTask.isRemovingWorldEntity(entity)) {
                    this.removeEntity((Entity)entity);
                    continue;
                }
                Runnable runnable = () -> {
                    Location livingEntityLoc = entity.getLocation();
                    TownBlock townBlock = TownyAPI.getInstance().getTownBlock(livingEntityLoc);
                    if (townBlock == null) {
                        if (townyWorld.hasWildernessMobs() || !MobRemovalTimerTask.isRemovingWildernessEntity(entity)) {
                            return;
                        }
                    } else {
                        if (townyWorld.isForceTownMobs() || townBlock.getPermissions().mobs || townBlock.getTownOrNull().isAdminEnabledMobs()) {
                            return;
                        }
                        if (!MobRemovalTimerTask.isRemovingTownEntity(entity)) {
                            return;
                        }
                    }
                    if (PluginIntegrations.getInstance().checkHostileEliteMobs((Entity)entity)) {
                        this.removeEntity((Entity)entity);
                        return;
                    }
                    if (entity instanceof Rabbit) {
                        Rabbit rabbit = (Rabbit)entity;
                        if (this.isRemovingKillerBunny && rabbit.getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY) {
                            this.removeEntity((Entity)entity);
                            return;
                        }
                    }
                    if (TownySettings.isSkippingRemovalOfNamedMobs() && entity.getCustomName() != null) {
                        return;
                    }
                    this.removeEntity((Entity)entity);
                };
                if (this.plugin.isFolia()) {
                    this.plugin.getScheduler().run((Entity)entity, runnable);
                    continue;
                }
                runnable.run();
            }
        }
    }

    private void removeEntity(@NotNull Entity entity) {
        if (MobRemovalEvent.getHandlerList().getRegisteredListeners().length > 0 && BukkitTools.isEventCancelled(new MobRemovalEvent(entity))) {
            return;
        }
        if (!this.plugin.getScheduler().isEntityThread(entity)) {
            this.plugin.getScheduler().run(entity, () -> ((Entity)entity).remove());
        } else {
            entity.remove();
        }
    }

    private void populateFields() {
        classesOfWorldMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWorldMobRemovalEntities(), "WorldMob: ");
        classesOfWildernessMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWildernessMobRemovalEntities(), "WildernessMob: ");
        classesOfTownMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getTownMobRemovalEntities(), "TownMob: ");
        this.isRemovingKillerBunny = TownySettings.isRemovingKillerBunny();
    }
}

