/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.scheduling.impl;

import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.scheduling.TaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.FoliaScheduledTask;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FoliaTaskScheduler
implements TaskScheduler {
    private final RegionScheduler regionScheduler = Bukkit.getServer().getRegionScheduler();
    private final GlobalRegionScheduler globalRegionScheduler = Bukkit.getServer().getGlobalRegionScheduler();
    private final AsyncScheduler asyncScheduler = Bukkit.getServer().getAsyncScheduler();
    private final Plugin plugin;

    public FoliaTaskScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isGlobalThread() {
        return Bukkit.getServer().isGlobalTickThread();
    }

    @Override
    public boolean isTickThread() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    public boolean isEntityThread(@NotNull Entity entity) {
        return Bukkit.getServer().isOwnedByCurrentRegion(entity);
    }

    @Override
    public boolean isRegionThread(@NotNull Location location) {
        return Bukkit.getServer().isOwnedByCurrentRegion(location);
    }

    @Override
    @NotNull
    public ScheduledTask run(@NotNull Runnable runnable) {
        return new FoliaScheduledTask(this.globalRegionScheduler.run(this.plugin, task -> runnable.run()));
    }

    @Override
    @NotNull
    public ScheduledTask run(@NotNull Entity entity, @NotNull Runnable runnable) {
        return new FoliaScheduledTask(entity.getScheduler().run(this.plugin, task -> runnable.run(), null));
    }

    @Override
    @NotNull
    public ScheduledTask run(@NotNull Location location, @NotNull Runnable runnable) {
        return new FoliaScheduledTask(this.regionScheduler.run(this.plugin, location, task -> runnable.run()));
    }

    @Override
    @NotNull
    public ScheduledTask runLater(@NotNull Runnable runnable, long delay) {
        if (delay == 0L) {
            return this.run(runnable);
        }
        return new FoliaScheduledTask(this.globalRegionScheduler.runDelayed(this.plugin, task -> runnable.run(), delay));
    }

    @Override
    @NotNull
    public ScheduledTask runLater(@NotNull Entity entity, @NotNull Runnable runnable, long delay) {
        if (delay == 0L) {
            return this.run(entity, runnable);
        }
        return new FoliaScheduledTask(entity.getScheduler().runDelayed(this.plugin, task -> runnable.run(), null, delay));
    }

    @Override
    @NotNull
    public ScheduledTask runLater(@NotNull Location location, @NotNull Runnable runnable, long delay) {
        if (delay == 0L) {
            return this.run(location, runnable);
        }
        return new FoliaScheduledTask(this.regionScheduler.runDelayed(this.plugin, location, task -> runnable.run(), delay));
    }

    @Override
    @NotNull
    public ScheduledTask runRepeating(@NotNull Runnable runnable, long delay, long period) {
        return new FoliaScheduledTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, task -> runnable.run(), delay, period));
    }

    @Override
    @NotNull
    public ScheduledTask runRepeating(@NotNull Entity entity, @NotNull Runnable runnable, long delay, long period) {
        return new FoliaScheduledTask(entity.getScheduler().runAtFixedRate(this.plugin, task -> runnable.run(), null, delay, period));
    }

    @Override
    @NotNull
    public ScheduledTask runRepeating(@NotNull Location location, @NotNull Runnable runnable, long delay, long period) {
        return new FoliaScheduledTask(this.regionScheduler.runAtFixedRate(this.plugin, location, task -> runnable.run(), delay, period));
    }

    @Override
    @NotNull
    public ScheduledTask runAsync(@NotNull Runnable runnable) {
        return new FoliaScheduledTask(this.asyncScheduler.runNow(this.plugin, task -> runnable.run()));
    }

    @Override
    @NotNull
    public ScheduledTask runAsyncLater(@NotNull Runnable runnable, long delay) {
        if (delay == 0L) {
            return this.runAsync(runnable);
        }
        return new FoliaScheduledTask(this.asyncScheduler.runDelayed(this.plugin, task -> runnable.run(), delay * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    @NotNull
    public ScheduledTask runAsyncRepeating(@NotNull Runnable runnable, long delay, long period) {
        return new FoliaScheduledTask(this.asyncScheduler.runAtFixedRate(this.plugin, task -> runnable.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS));
    }
}

