/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.actions.TownyExplodingBlocksEvent;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.WorldCoordEntityRemover;
import com.palmergames.bukkit.towny.regen.WorldCoordMaterialRemover;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyRegenAPI {
    private static List<WorldCoord> regenWorldCoordList = new ArrayList<WorldCoord>();
    private static Hashtable<String, PlotBlockData> plotChunks = new Hashtable();
    private static final Hashtable<BlockLocation, ProtectionRegenTask> protectionRegenTasks = new Hashtable();
    private static final Set<Block> protectionPlaceholders = new HashSet<Block>();

    public static void turnOffRevertOnUnclaimForWorld(TownyWorld world) {
        TownyRegenAPI.removeRegenQueueListOfWorld(world);
        TownyRegenAPI.removePlotChunksForWorld(world);
    }

    public static void finishPlotBlockData(PlotBlockData plotChunk) {
        TownyMessaging.sendDebugMsg("Revert on unclaim complete for " + plotChunk.getWorldName() + " " + plotChunk.getX() + "," + plotChunk.getZ());
        TownyRegenAPI.removeFromRegenQueueList(plotChunk.getWorldCoord());
        TownyRegenAPI.removeFromActiveRegeneration(plotChunk);
        TownyRegenAPI.deletePlotChunkSnapshot(plotChunk);
        plotChunk.getWorldCoord().unloadChunks();
    }

    @Deprecated
    public static void addWorldCoord(WorldCoord worldCoord) {
    }

    @Deprecated
    public static void removeWorldCoord(WorldCoord worldCoord) {
    }

    @Deprecated
    public static boolean hasWorldCoords() {
        return false;
    }

    @Deprecated
    public static boolean hasWorldCoord(WorldCoord worldCoord) {
        return false;
    }

    @Deprecated
    public static WorldCoord getWorldCoord() {
        return null;
    }

    public static List<WorldCoord> getRegenQueueList() {
        return regenWorldCoordList;
    }

    public static boolean regenQueueHasAvailable() {
        return !regenWorldCoordList.isEmpty();
    }

    private static void removeRegenQueueListOfWorld(@NotNull TownyWorld world) {
        regenWorldCoordList = TownyRegenAPI.getRegenQueueList().stream().filter(wc -> !world.equals(wc.getTownyWorld())).collect(Collectors.toList());
        TownyUniverse.getInstance().getDataSource().saveRegenList();
    }

    public static void removeFromRegenQueueList(WorldCoord wc) {
        if (regenWorldCoordList.remove(wc)) {
            TownyUniverse.getInstance().getDataSource().saveRegenList();
        }
    }

    public static void addToRegenQueueList(WorldCoord wc, boolean save) {
        if (regenWorldCoordList.contains(wc)) {
            return;
        }
        regenWorldCoordList.add(wc);
        if (save) {
            TownyUniverse.getInstance().getDataSource().saveRegenList();
        }
    }

    public static void getWorldCoordFromQueueForRegeneration() {
        for (WorldCoord wc : new ArrayList<WorldCoord>(TownyRegenAPI.getRegenQueueList())) {
            if (TownyRegenAPI.getPlotChunks().size() >= 20) break;
            if (TownyRegenAPI.hasActiveRegeneration(wc)) continue;
            PlotBlockData plotData = TownyRegenAPI.getPlotChunkSnapshot(new TownBlock(wc.getX(), wc.getZ(), wc.getTownyWorld()));
            if (plotData != null) {
                plotData.getWorldCoord().loadChunks();
                TownyRegenAPI.addToActiveRegeneration(plotData);
                TownyMessaging.sendDebugMsg("Revert on unclaim beginning for " + plotData.getWorldName() + " " + plotData.getX() + "," + plotData.getZ());
                continue;
            }
            TownyRegenAPI.removeFromRegenQueueList(wc);
        }
    }

    public static Hashtable<String, PlotBlockData> getPlotChunks() {
        return plotChunks;
    }

    public static List<PlotBlockData> getActivePlotBlockDatas() {
        return new ArrayList<PlotBlockData>(plotChunks.values());
    }

    public static boolean hasActiveRegenerations() {
        return !plotChunks.isEmpty();
    }

    public static boolean hasActiveRegeneration(WorldCoord wc) {
        return plotChunks.containsKey(TownyRegenAPI.getPlotKey(wc));
    }

    private static void removePlotChunksForWorld(TownyWorld world) {
        Hashtable<String, PlotBlockData> plotChunks = new Hashtable<String, PlotBlockData>();
        for (String key : TownyRegenAPI.getPlotChunks().keySet()) {
            if (TownyRegenAPI.getPlotChunks().get(key).getWorldName().equals(world.getName())) continue;
            plotChunks.put(key, TownyRegenAPI.getPlotChunks().get(key));
        }
        TownyRegenAPI.plotChunks = plotChunks;
    }

    public static void removeFromActiveRegeneration(PlotBlockData plotChunk) {
        plotChunks.remove(TownyRegenAPI.getPlotKey(plotChunk));
    }

    public static void addToActiveRegeneration(PlotBlockData plotChunk) {
        if (!plotChunks.containsKey(TownyRegenAPI.getPlotKey(plotChunk))) {
            plotChunks.put(TownyRegenAPI.getPlotKey(plotChunk), plotChunk);
        }
    }

    public static void addPlotChunkSnapshot(PlotBlockData plotChunk) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        TownBlock townBlock = plotChunk.getWorldCoord().getTownBlockOrNull();
        if (townBlock == null || !townyUniverse.getDataSource().hasPlotData(townBlock)) {
            townyUniverse.getDataSource().savePlotData(plotChunk);
        }
    }

    private static void deletePlotChunkSnapshot(PlotBlockData plotChunk) {
        TownyUniverse.getInstance().getDataSource().deletePlotData(plotChunk);
    }

    public static PlotBlockData getPlotChunkSnapshot(TownBlock townBlock) {
        return TownyUniverse.getInstance().getDataSource().loadPlotData(townBlock);
    }

    public static PlotBlockData getPlotChunk(TownBlock townBlock) {
        if (plotChunks.containsKey(TownyRegenAPI.getPlotKey(townBlock))) {
            return plotChunks.get(TownyRegenAPI.getPlotKey(townBlock));
        }
        return null;
    }

    private static String getPlotKey(PlotBlockData plotChunk) {
        return "[" + plotChunk.getWorldName() + "|" + plotChunk.getX() + "|" + plotChunk.getZ() + "]";
    }

    public static String getPlotKey(TownBlock townBlock) {
        return "[" + townBlock.getWorld().getName() + "|" + townBlock.getX() + "|" + townBlock.getZ() + "]";
    }

    public static String getPlotKey(WorldCoord wc) {
        return "[" + wc.getWorldName() + "|" + wc.getX() + "|" + wc.getZ() + "]";
    }

    public static boolean beginProtectionRegenTask(Block block, int count, TownyWorld world, Event event) {
        if (!TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) {
            if (block.getType() == Material.PISTON_HEAD) {
                Block baseBlock;
                PistonHead blockData = (PistonHead)block.getBlockData();
                block = baseBlock = block.getRelative(blockData.getFacing().getOppositeFace());
            }
            ProtectionRegenTask task = new ProtectionRegenTask(Towny.getPlugin(), block);
            task.setTask(Towny.getPlugin().getScheduler().runLater(block.getLocation(), (Runnable)task, (world.getPlotManagementWildRevertDelay() + (long)count) * 20L));
            TownyRegenAPI.addProtectionRegenTask(task);
            if (event instanceof TownyExplodingBlocksEvent) {
                event = ((TownyExplodingBlocksEvent)event).getBukkitExplodeEvent();
            }
            if (event instanceof EntityExplodeEvent) {
                ((EntityExplodeEvent)event).setYield(0.0f);
            } else if (event instanceof BlockExplodeEvent) {
                ((BlockExplodeEvent)event).setYield(0.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean hasProtectionRegenTask(BlockLocation blockLocation) {
        return protectionRegenTasks.containsKey(blockLocation);
    }

    public static ProtectionRegenTask GetProtectionRegenTask(BlockLocation blockLocation) {
        if (protectionRegenTasks.containsKey(blockLocation)) {
            return protectionRegenTasks.get(blockLocation);
        }
        return null;
    }

    public static void addProtectionRegenTask(ProtectionRegenTask task) {
        protectionRegenTasks.put(task.getBlockLocation(), task);
    }

    public static void removeProtectionRegenTask(ProtectionRegenTask task) {
        protectionRegenTasks.remove(task.getBlockLocation());
        if (protectionRegenTasks.isEmpty()) {
            protectionPlaceholders.clear();
        }
    }

    public static void cancelProtectionRegenTasks() {
        boolean replaceProtections = true;
        try {
            if (Class.forName("org.spigotmc.WatchdogThread").isInstance(Thread.currentThread())) {
                Towny.getPlugin().getLogger().severe("Detected a watchdog crash, ongoing protection revert tasks will not be finished.");
                replaceProtections = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (ProtectionRegenTask task : protectionRegenTasks.values()) {
            task.getTask().cancel();
            if (!replaceProtections) continue;
            task.replaceProtections();
        }
        protectionRegenTasks.clear();
        protectionPlaceholders.clear();
    }

    public static boolean isPlaceholder(Block block) {
        return protectionPlaceholders.contains(block);
    }

    public static void addPlaceholder(Block block) {
        protectionPlaceholders.add(block);
    }

    public static void removePlaceholder(Block block) {
        protectionPlaceholders.remove(block);
    }

    @Deprecated
    public static boolean hasDeleteTownBlockEntityQueue() {
        return WorldCoordEntityRemover.hasQueue();
    }

    @Deprecated
    public static boolean isDeleteTownBlockEntityQueue(WorldCoord plot) {
        return WorldCoordEntityRemover.isQueued(plot);
    }

    @Deprecated
    public static void addDeleteTownBlockEntityQueue(WorldCoord plot) {
        WorldCoordEntityRemover.addToQueue(plot);
    }

    @Deprecated
    @Nullable
    public static WorldCoord getDeleteTownBlockEntityQueue() {
        return WorldCoordEntityRemover.getWorldCoordFromQueue();
    }

    @Deprecated
    public static void doDeleteTownBlockEntities(WorldCoord worldCoord) {
        WorldCoordEntityRemover.doDeleteTownBlockEntities(worldCoord);
    }

    @Deprecated
    public static boolean hasDeleteTownBlockIdQueue() {
        return WorldCoordMaterialRemover.hasQueue();
    }

    @Deprecated
    public static boolean isDeleteTownBlockIdQueue(WorldCoord plot) {
        return WorldCoordMaterialRemover.isQueued(plot);
    }

    @Deprecated
    public static void addDeleteTownBlockIdQueue(WorldCoord plot) {
        WorldCoordMaterialRemover.addToQueue(plot);
    }

    @Deprecated
    @Nullable
    public static WorldCoord getDeleteTownBlockIdQueue() {
        return WorldCoordMaterialRemover.getWorldCoordFromQueue();
    }

    @Deprecated
    public static void doDeleteTownBlockIds(WorldCoord worldCoord) {
        WorldCoordMaterialRemover.queueUnclaimMaterialsDeletion(worldCoord);
    }

    @Deprecated
    public static void deleteTownBlockMaterial(TownBlock townBlock, Material material) {
        WorldCoordMaterialRemover.queueDeleteWorldCoordMaterials(townBlock.getWorldCoord(), Collections.singleton(material));
    }

    @Deprecated
    public static void deleteMaterialsFromTownBlock(TownBlock townBlock, Collection<Material> materials) {
        WorldCoordMaterialRemover.queueDeleteWorldCoordMaterials(townBlock.getWorldCoord(), materials);
    }

    @Deprecated
    public static /* bridge */ /* synthetic */ void deleteMaterialsFromTownBlock(TownBlock townBlock, EnumSet<?> materialEnumSet) {
        TownyRegenAPI.deleteMaterialsFromTownBlock(townBlock, materialEnumSet);
    }

    @Deprecated
    public static void deleteMaterialsFromWorldCoord(WorldCoord coord, Collection<Material> collection) {
        WorldCoordMaterialRemover.queueDeleteWorldCoordMaterials(coord, collection);
    }

    public static void handleNewSnapshot(@NotNull TownBlock townBlock) {
        ((CompletableFuture)TownyRegenAPI.createPlotSnapshot(townBlock).thenAcceptAsync(data -> {
            if (data.getBlockList().isEmpty()) {
                return;
            }
            TownyRegenAPI.addPlotChunkSnapshot(data);
        })).exceptionally(e -> {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred while creating a plot snapshot for " + townBlock.getWorldCoord().toString(), (Throwable)e);
            return null;
        });
    }

    public static CompletableFuture<PlotBlockData> createPlotSnapshot(@NotNull TownBlock townBlock) {
        ArrayList snapshots = new ArrayList();
        Collection<CompletableFuture<Chunk>> futures = townBlock.getWorldCoord().getChunks();
        futures.forEach(future -> future.thenAccept(chunk -> snapshots.add(chunk.getChunkSnapshot(false, false, false))));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApplyAsync(v -> {
            PlotBlockData data = new PlotBlockData(townBlock);
            data.initialize(snapshots);
            return data;
        });
    }
}

