/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.block.BlockObject;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

public class PlotBlockData {
    private final int defaultVersion = 5;
    private final String worldName;
    private final TownBlock townBlock;
    private int x;
    private int z;
    private int size;
    private int height;
    private int minHeight;
    private int version;
    private final List<String> blockList = new ArrayList<String>();
    private int blockListRestored;

    public PlotBlockData(TownBlock townBlock) {
        this.townBlock = townBlock;
        this.setX(townBlock.getX());
        this.setZ(townBlock.getZ());
        this.setSize(TownySettings.getTownBlockSize());
        this.worldName = townBlock.getWorld().getName();
        this.setVersion(5);
        this.setHeight(townBlock.getWorldCoord().getBukkitWorld().getMaxHeight() - 1);
        this.setMinHeight(townBlock.getWorldCoord().getBukkitWorld().getMinHeight());
        this.blockListRestored = 0;
    }

    public void initialize(List<ChunkSnapshot> snapshots) {
        List<String> blocks = this.getBlockArr(snapshots);
        if (!blocks.isEmpty()) {
            this.setBlockList(blocks);
            this.resetBlockListRestored();
        }
    }

    private List<String> getBlockArr(List<ChunkSnapshot> snapshots) {
        ArrayList<String> blocks = new ArrayList<String>();
        ChunkSnapshot single = snapshots.size() == 1 && this.size == 16 ? snapshots.get(0) : null;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        if (world == null) {
            return blocks;
        }
        for (int z = 0; z < this.size; ++z) {
            for (int x = 0; x < this.size; ++x) {
                for (int y = this.height; y > this.minHeight; --y) {
                    if (single != null) {
                        blocks.add(single.getBlockData(x, y, z).getAsString(true));
                        continue;
                    }
                    blocks.add(this.lookupData(snapshots, x, y, z).getAsString(true));
                }
            }
        }
        return blocks;
    }

    private BlockData lookupData(List<ChunkSnapshot> snapshots, int x, int y, int z) {
        int worldX = this.getX() * this.size + x;
        int worldZ = this.getZ() * this.size + z;
        int chunkX = worldX >> 4;
        int chunkZ = worldZ >> 4;
        for (ChunkSnapshot snapshot : snapshots) {
            if (snapshot.getX() != chunkX || snapshot.getZ() != chunkZ) continue;
            return snapshot.getBlockData(worldX & 0xF, y, worldZ & 0xF);
        }
        return Material.AIR.createBlockData();
    }

    public boolean restoreNextBlock() {
        int worldx = this.getX() * this.size;
        int worldz = this.getZ() * this.size;
        int yRange = Math.abs(this.minHeight) + this.height;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        if (world == null || !world.isChunkLoaded(BukkitTools.calcChunk(this.getX()), BukkitTools.calcChunk(this.getZ()))) {
            return true;
        }
        if (this.version < 4) {
            TownyMessaging.sendErrorMsg("Towny found a plotsnapshot which is from a version too old to use!");
            return false;
        }
        int reverse = this.blockList.size() - this.blockListRestored;
        while (reverse > 0) {
            BlockObject storedData;
            ++this.blockListRestored;
            int y = this.height - --reverse % yRange;
            int x = reverse / yRange % this.size;
            int z = reverse / yRange / this.size % this.size;
            Block block = world.getBlockAt(worldx + x, y, worldz + z);
            Material blockMat = block.getType();
            try {
                storedData = this.getStoredBlockData(this.blockList.size() - this.blockListRestored);
            }
            catch (IllegalArgumentException e1) {
                TownyMessaging.sendDebugMsg("Towny's revert-on-unclaim feature encountered a block which will not load on the current version of MC. Ignoring and skipping to next block.");
                continue;
            }
            Material mat = storedData.getMaterial();
            if (mat == null || blockMat == mat) continue;
            if (!this.townBlock.getWorld().isUnclaimedBlockAllowedToRevert(mat)) {
                block.setType(Material.AIR);
                return true;
            }
            try {
                block.setType(mat, false);
                block.setBlockData(storedData.getBlockData());
                return true;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Exception in PlotBlockData.java");
                break;
            }
        }
        this.resetBlockListRestored();
        return false;
    }

    private BlockObject getStoredBlockData(int index) {
        return new BlockObject(this.blockList.get(index));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<String> getBlockList() {
        return this.blockList;
    }

    public void setBlockList(@NotNull List<String> blockList) {
        this.blockList.clear();
        this.blockList.addAll(blockList);
    }

    public void resetBlockListRestored() {
        this.blockListRestored = 0;
    }

    public WorldCoord getWorldCoord() {
        return this.townBlock.getWorldCoord();
    }
}

