/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyPerms {
    protected static final LinkedHashMap<String, Permission> registeredPermissions = new LinkedHashMap();
    protected static final HashMap<String, PermissionAttachment> attachments = new HashMap();
    private static final HashMap<String, List<String>> groupPermsMap = new HashMap();
    private static CommentedConfiguration perms;
    private static Towny plugin;
    private static final List<String> vitalGroups;
    private static final HashMap<UUID, String> residentPrefixMap;
    private static final String RANKPRIORITY_PREFIX = "towny.rankpriority.";
    private static final String RANKPREFIX_PREFIX = "towny.rankprefix.";
    private static final MethodHandle PERMISSIONS;

    public static void initialize(Towny plugin) {
        TownyPerms.plugin = plugin;
    }

    public static void loadPerms(@NotNull Path permsYMLPath) {
        try {
            InputStream resource = Towny.class.getResourceAsStream("/townyperms.yml");
            if (resource == null) {
                throw new TownyInitException("Could not find 'townyperms.yml' in the JAR.", TownyInitException.TownyError.PERMISSIONS);
            }
            Files.copy(resource, permsYMLPath, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException resource) {
        }
        catch (IOException e) {
            throw new TownyInitException("Could not copy townyperms.yml from JAR to '" + permsYMLPath + "'.", TownyInitException.TownyError.PERMISSIONS, e);
        }
        perms = new CommentedConfiguration(permsYMLPath);
        if (!perms.load()) {
            throw new TownyInitException("Could not read townyperms.yml", TownyInitException.TownyError.PERMISSIONS);
        }
        groupPermsMap.clear();
        TownyPerms.buildGroupPermsMap();
        TownyPerms.checkForVitalGroups();
        TownyPerms.buildComments();
        perms.save();
        TownyPerms.collectPermissions();
    }

    private static void checkForVitalGroups() {
        for (String group : vitalGroups) {
            if (groupPermsMap.containsKey(group)) continue;
            throw new TownyInitException(TownyPerms.getErrorMessageForGroup(group), TownyInitException.TownyError.PERMISSIONS);
        }
    }

    @NotNull
    private static String getErrorMessageForGroup(String group) {
        if (!group.contains(".")) {
            return "Your townyperms.yml is missing the " + group + " group. Maybe you renamed it?";
        }
        String[] split = group.split("\\.");
        return "Your townyperms.yml's " + split[0] + " section is missing the " + split[1] + " group. Maybe you renamed it?";
    }

    public static void assignPermissions(Resident resident, Player player) {
        if (resident == null) {
            if (player != null) {
                resident = TownyAPI.getInstance().getResident(player);
            }
            if (resident == null) {
                return;
            }
        } else {
            player = resident.getPlayer();
        }
        if (player == null || !player.isOnline()) {
            attachments.remove(resident.getName());
            return;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null) {
            return;
        }
        Player finalPlayer = player;
        PermissionAttachment attachment = attachments.computeIfAbsent(resident.getName(), k -> finalPlayer.addAttachment((Plugin)plugin));
        try {
            Map orig = PERMISSIONS.invoke(attachment);
            orig.clear();
            if (world.isUsingTowny()) {
                orig.putAll(TownyPerms.getResidentPerms(resident));
            }
            player.recalculatePermissions();
        }
        catch (Throwable e) {
            plugin.getLogger().log(Level.WARNING, "exception occurred while assigning permissions to player " + player.getName(), e);
        }
        attachments.put(resident.getName(), attachment);
        TownyPerms.setResidentPrimaryRankPrefix(resident);
    }

    public static void removeAttachment(String name) {
        attachments.remove(name);
    }

    public static void updateOnlinePerms() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            TownyPerms.assignPermissions(null, player);
        }
    }

    public static void updateTownPerms(Town town) {
        for (Resident resident : town.getResidents()) {
            TownyPerms.assignPermissions(resident, null);
        }
    }

    public static void updateNationPerms(Nation nation) {
        for (Town town : nation.getTowns()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static List<String> getList(String path) {
        if (perms.contains(path)) {
            return perms.getStringList(path);
        }
        return new ArrayList<String>();
    }

    public static LinkedHashMap<String, Boolean> getResidentPerms(Resident resident) {
        HashSet<String> permList = new HashSet<String>(TownyPerms.getDefault());
        if (resident.hasTown()) {
            permList.addAll(TownyPerms.getTownDefault(TownyPerms.getTownName(resident)));
            if (resident.isMayor()) {
                permList.addAll(TownyPerms.getTownMayor());
            }
            for (String rank : resident.getTownRanks()) {
                permList.addAll(TownyPerms.getTownRankPermissions(rank));
            }
            if (resident.hasNation()) {
                permList.addAll(TownyPerms.getNationDefault(TownyPerms.getNationName(resident)));
                if (resident.isKing()) {
                    permList.addAll(TownyPerms.getNationKing());
                }
                for (String rank : resident.getNationRanks()) {
                    permList.addAll(TownyPerms.getNationRankPermissions(rank));
                }
            } else {
                permList.add("towny.nationless");
            }
            if (TownyPerms.isPeaceful(resident.getTownOrNull())) {
                permList.addAll(TownyPerms.getList("peaceful"));
            }
        } else {
            permList.add("towny.townless");
            permList.add("towny.nationless");
        }
        List<String> playerPermArray = TownyPerms.sort(new ArrayList<String>(permList));
        LinkedHashMap<String, Boolean> newPerms = new LinkedHashMap<String, Boolean>();
        Boolean value = false;
        for (String permission : playerPermArray) {
            String placeholderPerm;
            if (permission.contains("{townname}")) {
                if (!resident.hasTown()) continue;
                placeholderPerm = permission.replace("{townname}", TownyPerms.getTownName(resident));
                newPerms.put(placeholderPerm, true);
                continue;
            }
            if (permission.contains("{nationname}")) {
                if (!resident.hasNation()) continue;
                placeholderPerm = permission.replace("{nationname}", TownyPerms.getNationName(resident));
                newPerms.put(placeholderPerm, true);
                continue;
            }
            value = !permission.startsWith("-");
            newPerms.put(value != false ? permission : permission.substring(1), value);
        }
        return newPerms;
    }

    public static void registerPermissionNodes() {
        plugin.getScheduler().runLater(() -> {
            Permission perm;
            for (String rank : TownyPerms.getTownRanks()) {
                perm = new Permission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                perm.addParent(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(), true);
            }
            for (String rank : TownyPerms.getNationRanks()) {
                perm = new Permission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank), "User can grant this nation rank to others..", PermissionDefault.FALSE, null);
                perm.addParent(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(), true);
            }
        }, 1L);
    }

    public static List<String> getDefault() {
        return TownyPerms.getList("nomad");
    }

    public static List<String> getTownRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("towns.ranks")).getKeys(false));
    }

    public static List<String> getTownDefault(String townName) {
        List<String> permsList = TownyPerms.getList("towns.default");
        permsList.add("towny.town." + townName);
        return permsList;
    }

    public static List<String> getTownMayor() {
        return TownyPerms.getList("towns.mayor");
    }

    public static List<String> getTownRankPermissions(String rank) {
        return TownyPerms.getList("towns.ranks." + rank);
    }

    public static List<String> getNationRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("nations.ranks")).getKeys(false));
    }

    public static List<String> getNationDefault(String nationName) {
        List<String> permsList = TownyPerms.getList("nations.default");
        permsList.add("towny.nation." + nationName);
        return permsList;
    }

    public static List<String> getNationKing() {
        return TownyPerms.getList("nations.king");
    }

    public static List<String> getNationRankPermissions(String rank) {
        return TownyPerms.getList("nations.ranks." + rank);
    }

    @Nullable
    public static String matchNationRank(String rank) {
        for (String nationRank : TownyPerms.getNationRanks()) {
            if (!nationRank.equalsIgnoreCase(rank)) continue;
            return nationRank;
        }
        return null;
    }

    @Nullable
    public static String matchTownRank(String rank) {
        for (String townRank : TownyPerms.getTownRanks()) {
            if (!townRank.equalsIgnoreCase(rank)) continue;
            return townRank;
        }
        return null;
    }

    private static String getTownName(Resident resident) {
        return resident.getTownOrNull().getName().toLowerCase(Locale.ROOT);
    }

    private static String getNationName(Resident resident) {
        return resident.getNationOrNull().getName().toLowerCase(Locale.ROOT);
    }

    private static boolean isPeaceful(Town town) {
        return town.isNeutral() || town.hasNation() && town.getNationOrNull().isNeutral();
    }

    public static boolean hasPeacefulNodes() {
        return !TownyPerms.getList("peaceful").isEmpty();
    }

    public static String getResidentPrimaryRankPrefix(Resident resident) {
        return residentPrefixMap.getOrDefault(resident.getUUID(), TownyPerms.setResidentPrimaryRankPrefix(resident));
    }

    private static String setResidentPrimaryRankPrefix(Resident resident) {
        String prefix = TownyPerms.getPrimaryRankPrefix(resident);
        residentPrefixMap.put(resident.getUUID(), prefix);
        return prefix;
    }

    private static String getPrimaryRankPrefix(Resident resident) {
        String prefix = TownyPerms.getHighestPriorityRankPrefix(resident);
        return prefix == null ? "" : prefix;
    }

    @Nullable
    private static String getHighestPriorityRankPrefix(Resident resident) {
        String rank;
        String prefix;
        if (resident.hasNation() && !resident.getNationRanks().isEmpty() && (prefix = TownyPerms.getPrefixFromRank(TownyPerms.getNationRankPermissions(rank = TownyPerms.getHighestPriorityRank(resident, resident.getNationRanks(), r -> TownyPerms.getNationRankPermissions(r))))) != null) {
            return prefix;
        }
        if (resident.hasTown() && !resident.getTownRanks().isEmpty() && (prefix = TownyPerms.getPrefixFromRank(TownyPerms.getTownRankPermissions(rank = TownyPerms.getHighestPriorityRank(resident, resident.getTownRanks(), r -> TownyPerms.getTownRankPermissions(r))))) != null) {
            return prefix;
        }
        return null;
    }

    private static String getPrefixFromRank(List<String> nodes) {
        for (String node : nodes) {
            if (!node.startsWith(RANKPREFIX_PREFIX)) continue;
            return node.substring(RANKPREFIX_PREFIX.length());
        }
        return null;
    }

    public static String getHighestPriorityRank(Resident resident, List<String> ranks, Function<String, List<String>> rankFunction) {
        HashMap<String, Integer> rankPriorityMap = new HashMap<String, Integer>();
        for (String rank : ranks) {
            rankPriorityMap.put(rank, TownyPerms.getRankPriority(rankFunction.apply(rank)));
        }
        return (String)Collections.max(rankPriorityMap.entrySet(), Comparator.comparingInt(Map.Entry::getValue)).getKey();
    }

    private static int getRankPriority(List<String> nodes) {
        int topValue = 0;
        for (String node : nodes) {
            int priorityValue;
            if (!node.startsWith(RANKPRIORITY_PREFIX) || topValue >= (priorityValue = TownyPerms.getNodePriority(node))) continue;
            topValue = priorityValue;
        }
        return topValue;
    }

    private static int getNodePriority(String node) {
        try {
            return Integer.valueOf(node.substring(RANKPRIORITY_PREFIX.length()));
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    public static void collectPermissions() {
        registeredPermissions.clear();
        for (Permission perm : BukkitTools.getPluginManager().getPermissions()) {
            registeredPermissions.put(perm.getName().toLowerCase(), perm);
        }
    }

    private static List<String> sort(List<String> permList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : permList) {
            String a = key.charAt(0) == '-' ? key.substring(1) : key;
            Map<String, Boolean> allchildren = TownyPerms.getAllChildren(a, new HashSet<String>());
            if (allchildren != null) {
                ListIterator<String> itr = result.listIterator();
                while (itr.hasNext()) {
                    String node = (String)itr.next();
                    String b = node.charAt(0) == '-' ? node.substring(1) : node;
                    if (!allchildren.containsKey(b)) continue;
                    itr.set(key);
                    itr.add(node);
                    break;
                }
            }
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getAllRegisteredPermissions(boolean includeChildren) {
        ArrayList<String> perms = new ArrayList<String>();
        for (String key : registeredPermissions.keySet()) {
            Map<String, Boolean> children;
            if (perms.contains(key)) continue;
            perms.add(key);
            if (!includeChildren || (children = TownyPerms.getAllChildren(key, new HashSet<String>())) == null) continue;
            for (String node : children.keySet()) {
                if (perms.contains(node)) continue;
                perms.add(node);
            }
        }
        return perms;
    }

    public static Map<String, Boolean> getAllChildren(String node, Set<String> playerPermArray) {
        LinkedList<String> stack = new LinkedList<String>();
        HashMap<String, Boolean> alreadyVisited = new HashMap<String, Boolean>();
        stack.push(node);
        alreadyVisited.put(node, true);
        while (!stack.isEmpty()) {
            String now = (String)stack.pop();
            Map<String, Boolean> children = TownyPerms.getChildren(now);
            if (children == null || playerPermArray.contains("-" + now)) continue;
            for (String childName : children.keySet()) {
                if (alreadyVisited.containsKey(childName)) continue;
                stack.push(childName);
                alreadyVisited.put(childName, children.get(childName));
            }
        }
        alreadyVisited.remove(node);
        if (!alreadyVisited.isEmpty()) {
            return alreadyVisited;
        }
        return null;
    }

    public static Map<String, Boolean> getChildren(String node) {
        Permission perm = registeredPermissions.get(node.toLowerCase());
        if (perm == null) {
            return null;
        }
        return perm.getChildren();
    }

    public static List<String> getGroupList() {
        return new ArrayList<String>(groupPermsMap.keySet());
    }

    public static boolean mapHasGroup(String group) {
        return groupPermsMap.containsKey(group);
    }

    public static List<String> getPermsOfGroup(String group) {
        return TownyPerms.mapHasGroup(group) ? (groupPermsMap.get(group) != null ? groupPermsMap.get(group) : new ArrayList()) : new ArrayList();
    }

    private static void buildGroupPermsMap() {
        perms.getKeys(true).stream().forEach(key -> groupPermsMap.put((String)key, perms.getStringList((String)key)));
    }

    private static void buildComments() {
        perms.addComment("nomad", "#############################################################################################", "# This file contains custom permission sets which will be assigned to your players          #", "# depending on their current status. This file uses YAML formatting. Do not include tabs    #", "# and be very careful to align the spacing preceding the - symbols. Improperly editing this #", "# file will prevent Towny from loading correctly.                                           #", "#                                                                                           #", "# This is all managed by towny and pushed directly to CraftBukkit's SuperPerms.             #", "# These will be give in addition to any you manually assign in your specific permission     #", "# plugin. Note: You do not need to assign any Towny permission nodes to your players in     #", "# your server's permission plugin, ie: LuckPerms.                                           #", "#                                                                                           #", "# You may assign any Permission nodes here, including those from other plugins.             #", "#                                                                                           #", "# You may also create any custom ranks you require. Creating ranks can be done using the    #", "# /ta townyperms townrank addrank [name] or by carefully editing this file.                 #", "# You can add permission to a rank/group using the                                          #", "# /ta townyperms group [name] addperm [node] command.                                       #", "#                                                                                           #", "# You may change the names of any of the ranks except: nomad, default, mayor, king, ranks,  #", "# peaceful.                                                                                 #", "#                                                                                           #", "# If you want to, you can negate permissions nodes from nodes by doing the following:       #", "# Ex:                                                                                       #", "#    - towny.command.plot.*                                                                 #", "#    - -towny.command.plot.set.jail                                                         #", "# In this example the user is given full rights to all of the /plot command nodes,          #", "# but has had their ability to set a plot to a Jail plot type disabled.                     #", "#                                                                                           #", "# The towns.ranks and nations.ranks sections support adding prefix and priorities, this     #", "# is done using two nodes: towny.rankpriority.# and towny.rankprefix.<prefix_here>.         #", "# Residents will have their ranks parsed until one rank is determined to be the highest     #", "# priority, this rank will then be searched for a prefix node. This prefix can be shown     #", "# using the %townyadvanced_resident_primary_rank% placeholder for PlaceholderAPI. A prefix  #", "# from a Nation rank will take precendence over a prefix from a Town rank.                  #", "# Ex:                                                                                       #", "#    - towny.rankpriority.100                                                               #", "#    - towny.rankprefix.&a<&2Sheriff&a>                                                     #", "#                                                                                           #", "#############################################################################################", "", "", "# The 'nomad' permissions are given to all players in all Towny worlds, townless and players who are part of a town.");
        perms.addComment("towns", "", "# This section of permissions covers players who are members of a town.");
        perms.addComment("towns.default", "", "# 'default' is the permission set which is auto assigned to any normal town member.");
        perms.addComment("towns.mayor", "", "# Mayors get these permissions in addition to the default set.");
        perms.addComment("towns.ranks", "", "# Ranks contain additional permissions residents will be", "# granted if they are assigned that specific rank.");
        if (perms.getKeys(true).contains("towns.ranks.assistant")) {
            perms.addComment("towns.ranks.assistant", "", "# assistants are able to grant VIP and helper rank.");
        }
        if (perms.getKeys(true).contains("towns.ranks.donator")) {
            perms.addComment("towns.ranks.donator", "", "# Currently only an example rank holder with no extra permissions.");
        }
        if (perms.getKeys(true).contains("towns.ranks.vip")) {
            perms.addComment("towns.ranks.vip", "", "# Currently only an example rank holder with no extra permissions.");
        }
        if (perms.getKeys(true).contains("towns.ranks.sheriff")) {
            perms.addComment("towns.ranks.sheriff", "", "# Sheriff rank is able to jail other town members.");
        }
        perms.addComment("nations", "", "# This section of permissions covers players who are members of any town in a nation.");
        perms.addComment("nations.default", "", "# All nation members get these permissions.");
        perms.addComment("nations.king", "", "# Kings get these permissions in addition to the default set.");
        perms.addComment("peaceful", "", "# Nodes that are given to players who are in a peaceful/neutral town or nation.");
    }

    public static CommentedConfiguration getTownyPermsFile() {
        return perms;
    }

    static {
        vitalGroups = Arrays.asList("nomad", "towns.default", "towns.mayor", "towns.ranks", "nations.default", "nations.king", "nations.ranks");
        residentPrefixMap = new HashMap();
        try {
            Field permissionsField = PermissionAttachment.class.getDeclaredField("permissions");
            permissionsField.setAccessible(true);
            PERMISSIONS = MethodHandles.lookup().unreflectGetter(permissionsField);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

