/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.adventure.util.TriState;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public abstract class TownyPermissionSource {
    protected TownySettings settings;
    protected Towny plugin;
    protected GroupManager groupManager = null;

    public abstract String getPrefixSuffix(Resident var1, String var2);

    public abstract int getGroupPermissionIntNode(String var1, String var2);

    public abstract int getPlayerPermissionIntNode(String var1, String var2);

    public abstract String getPlayerGroup(Player var1);

    public abstract String getPlayerPermissionStringNode(String var1, String var2);

    protected int getEffectivePermIntNode(String playerName, String node) {
        Player player = BukkitTools.getPlayerExact(playerName);
        if (player == null) {
            return -1;
        }
        int biggest = -1;
        for (PermissionAttachmentInfo test : player.getEffectivePermissions()) {
            if (!test.getPermission().startsWith(node + ".")) continue;
            String[] split = test.getPermission().split("\\.");
            try {
                int i = Integer.parseInt(split[split.length - 1]);
                biggest = Math.max(biggest, i);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return biggest;
    }

    public boolean hasWildOverride(TownyWorld world, Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_WILD_ALL.getNode(action.toString().toLowerCase() + "." + material);
        return this.testPermission((Permissible)player, blockPerm) || this.unclaimedZoneAction(world, material, action);
    }

    public boolean unclaimedZoneAction(TownyWorld world, Material material, TownyPermission.ActionType action) {
        switch (action) {
            case BUILD: {
                return world.getUnclaimedZoneBuild() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case DESTROY: {
                return world.getUnclaimedZoneDestroy() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case SWITCH: {
                return world.getUnclaimedZoneSwitch() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case ITEM_USE: {
                return world.getUnclaimedZoneItemUse() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
        }
        return false;
    }

    public boolean hasOwnTownOverride(Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_CLAIMED_OWNTOWN_ALL.getNode(action.toString().toLowerCase() + "." + material);
        return this.testPermission((Permissible)player, blockPerm) || this.hasAllTownOverride(player, material, action);
    }

    public boolean hasTownOwnedOverride(Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_CLAIMED_TOWNOWNED_ALL.getNode(action.toString().toLowerCase() + "." + material);
        return this.testPermission((Permissible)player, blockPerm) || this.hasOwnTownOverride(player, material, action) || this.hasAllTownOverride(player, material, action);
    }

    public boolean hasAllTownOverride(Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALLTOWN_ALL.getNode(action.toString().toLowerCase() + "." + material);
        return this.testPermission((Permissible)player, blockPerm);
    }

    public boolean isTownyAdmin(@NotNull Permissible permissible) {
        TriState has;
        block3: {
            block2: {
                has = this.strictHas(permissible, PermissionNodes.TOWNY_ADMIN.getNode());
                if (has == TriState.FALSE) break block2;
                if (!(permissible instanceof Player)) break block3;
                Player player = (Player)permissible;
                if (!Towny.getPlugin().hasPlayerMode(player, "adminbypass")) break block3;
            }
            return false;
        }
        return has == TriState.TRUE || permissible.isOp();
    }

    public void testPermissionOrThrow(Permissible permissible, String perm) throws NoPermissionException {
        if (!this.testPermission(permissible, perm)) {
            throw new NoPermissionException();
        }
    }

    public void testPermissionOrThrow(Permissible permissible, String perm, Translatable errormsg) throws NoPermissionException {
        if (!this.testPermission(permissible, perm)) {
            throw new NoPermissionException(errormsg);
        }
    }

    public boolean testPermission(Permissible permissible, String perm) {
        TriState has = this.strictHas(permissible, perm);
        if (has == TriState.FALSE) {
            return false;
        }
        return has == TriState.TRUE || this.isTownyAdmin(permissible);
    }

    @Deprecated
    public boolean testPermission(Permissible permissible, PermissionNodes node) {
        return this.testPermission(permissible, node.getNode());
    }

    @Deprecated
    public boolean has(Player player, String node) {
        return this.testPermission((Permissible)player, node);
    }

    private TriState strictHas(Permissible permissible, String node) {
        if (permissible.isPermissionSet(node)) {
            return TriState.byBoolean(permissible.hasPermission(node));
        }
        String[] parts = node.split("\\.");
        StringBuilder builder = new StringBuilder(node.length());
        for (String part : parts) {
            builder.append('*');
            String newNode = builder.toString();
            if (permissible.isPermissionSet(newNode)) {
                return TriState.byBoolean(permissible.hasPermission(newNode));
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(part).append('.');
        }
        return TriState.NOT_SET;
    }
}

