/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class LocationDataField
extends CustomDataField<Location> {
    public LocationDataField(String key) {
        super(key);
    }

    public LocationDataField(String key, Location location) {
        super(key, location);
    }

    public LocationDataField(String key, Location location, String label) {
        super(key, location, label);
    }

    @Override
    public String getTypeID() {
        return LocationDataField.typeID();
    }

    public static String typeID() {
        return "towny_locationdf";
    }

    @Override
    protected String serializeValueToString() {
        return ((Location)this.getValue()).getWorld().getUID() + "," + ((Location)this.getValue()).getX() + "," + ((Location)this.getValue()).getY() + "," + ((Location)this.getValue()).getZ() + "," + ((Location)this.getValue()).getPitch() + "," + ((Location)this.getValue()).getYaw() + ",";
    }

    @Override
    public void setValueFromString(String strValue) {
        Location location = null;
        String[] tokens = strValue.split(",");
        if (tokens.length >= 4) {
            try {
                location = new Location(Bukkit.getWorld((UUID)UUID.fromString(tokens[0])), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]), Double.parseDouble(tokens[3]));
                if (tokens.length == 6) {
                    location.setPitch(Float.parseFloat(tokens[4]));
                    location.setYaw(Float.parseFloat(tokens[5]));
                }
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        this.setValue(location);
    }

    @Override
    protected String displayFormattedValue() {
        return ((Location)this.getValue()).getWorld().getName() + "," + ((Location)this.getValue()).getX() + "," + ((Location)this.getValue()).getY() + "," + ((Location)this.getValue()).getZ() + "," + ((Location)this.getValue()).getPitch() + "," + ((Location)this.getValue()).getYaw();
    }

    @Override
    @NotNull
    public CustomDataField<Location> clone() {
        return new LocationDataField(this.getKey(), (Location)this.getValue(), this.label);
    }
}

