/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import org.jetbrains.annotations.NotNull;

public class ByteDataField
extends CustomDataField<Byte> {
    public ByteDataField(String key) {
        super(key);
    }

    public ByteDataField(String key, byte value, String label) {
        super(key, value, label);
    }

    public ByteDataField(String key, byte value) {
        super(key, value);
    }

    @Override
    @NotNull
    public String getTypeID() {
        return ByteDataField.typeID();
    }

    public static String typeID() {
        return "towny_bytedf";
    }

    @Override
    public void setValueFromString(String strValue) {
        this.setValue(Byte.parseByte(strValue));
    }

    @Override
    public boolean canParseFromString(String str) {
        try {
            Byte.parseByte(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public String displayFormattedValue() {
        return String.valueOf(this.getValue());
    }

    @Override
    @NotNull
    public CustomDataField<Byte> clone() {
        return new ByteDataField(this.getKey(), (Byte)this.getValue(), this.label);
    }
}

