/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.inviteobjects;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.inviteobjects.AbstractInvite;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public class TownJoinNationInvite
extends AbstractInvite<Nation, Town> {
    public TownJoinNationInvite(CommandSender directSender, Town receiver, Nation sender) {
        super(directSender, receiver, sender);
    }

    @Override
    public void accept() throws TownyException {
        Town town = (Town)this.getReceiver();
        ArrayList<Town> towns = new ArrayList<Town>();
        towns.add(town);
        Nation nation = (Nation)this.getSender();
        if (!town.hasNation()) {
            NationCommand.nationAdd(nation, towns);
        } else {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_err_already_nation", town.getName()));
        }
        town.deleteReceivedInvite(this);
        nation.deleteSentInvite(this);
    }

    @Override
    public void decline(boolean fromSender) {
        Town town = (Town)this.getReceiver();
        Nation nation = (Nation)this.getSender();
        town.deleteReceivedInvite(this);
        nation.deleteSentInvite(this);
        if (!fromSender) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_deny_invite", town.getName()));
        } else {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("nation_revoke_invite", nation.getName()));
        }
    }
}

