/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.inviteobjects;

import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.InviteSender;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractInvite<S extends InviteSender, R extends InviteReceiver>
implements Invite {
    private final UUID senderUUID;
    private final String senderName;
    private final R receiver;
    private final S sender;

    AbstractInvite(@NotNull CommandSender directSender, @NotNull R receiver, @NotNull S sender) {
        UUID uUID;
        String string = directSender.getName();
        if (directSender instanceof Player) {
            Player player = (Player)directSender;
            uUID = player.getUniqueId();
        } else {
            uUID = null;
        }
        this(string, uUID, receiver, sender);
    }

    AbstractInvite(@NotNull String senderName, @Nullable UUID senderUUID, @NotNull R receiver, @NotNull S sender) {
        this.senderName = senderName;
        this.senderUUID = senderUUID;
        this.receiver = receiver;
        this.sender = sender;
    }

    @Override
    @Nullable
    public CommandSender getDirectSender() {
        return this.senderUUID == null ? Bukkit.getConsoleSender() : Bukkit.getPlayer((UUID)this.senderUUID);
    }

    @Override
    @NotNull
    public String getSenderName() {
        return this.senderName;
    }

    @Override
    @Nullable
    public UUID getSenderUUID() {
        return this.senderUUID;
    }

    public R getReceiver() {
        return this.receiver;
    }

    public S getSender() {
        return this.sender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractInvite)) {
            return false;
        }
        AbstractInvite that = (AbstractInvite)o;
        return Objects.equals(this.getSenderName(), that.getSenderName()) && Objects.equals(this.getSenderUUID(), that.getSenderUUID()) && Objects.equals(this.getReceiver(), that.getReceiver()) && Objects.equals(this.getSender(), that.getSender());
    }

    public int hashCode() {
        return Objects.hash(this.getDirectSender(), this.getReceiver(), this.getSender());
    }
}

